<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/gallery_editpic.php - Admin frontend Picture Manipulation */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("thumbnail.inc.php");

include("header.php");

// Check if filename is sanitary
if(strstr($_GET['file'], '..') != "") {
        die('<b>Fatal error:</b> Filename can not have ".." in it.'); }

// Check if file is real
if(!file_exists($wg_phtml . "/pictures/" . $_GET['file'])) {
	die("<b>Fatal error:</b> Unknown file.\n"); }

// Do we have work to do?
$result = "none";
if($_GET['thing'] == "left") {
	if(rotate("left", $wg_phtml . '/pictures/' . $_GET['file']) && thumbnail($wg_phtml . '/pictures/' . $_GET['file'])) {
		$result = "<font color=\"green\">Rotated</font>";
	} else {
		$result = "<font color=\"red\">Failure</font>";
	}
} elseif ($_GET['thing'] == "right") {
	if(rotate("right", $wg_phtml . '/pictures/' . $_GET['file']) && thumbnail($wg_phtml . '/pictures/' . $_GET['file'])) {
		$result = "<font color=\"green\">Rotated</font>";
	} else {
		$result = "<font color=\"red\">Failure</font>";
	}
} elseif ($_GET['thing'] == "rebuild") {
	if(thumbnail($wg_phtml . '/pictures/' . $_GET['file'])) {
		$result = "<font color=\"green\">Rebuilt</font>";
	} else {
		$result = "<font color=\"red\">Failure</font>";
	}
}

?>
<table class="max blend">
	<tr><td><b>Viewing Picture:</b> Pictures/<?=$_GET['file']?><? if($result != "none") { ?> - <? echo $result; } ?></td><td align="right"><a href="<? echo($_SERVER['PHP_SELF'] . "?thing=left&file=" . $_GET['file']); ?>"><img alt="Rotate 90º left" src="left.png" /> <span class="dclick">Rotate 90&deg; Left</span></a> &nbsp; <a href="<? echo($_SERVER['PHP_SELF'] . "?thing=right&file=" . $_GET['file']); ?>"><img alt="Rotate 90º right" src="right.png" /> <span class="dclick">Rotate 90&deg; Right</span></a> &nbsp; <a href="<? echo($_SERVER['PHP_SELF'] . "?thing=rebuild&file=" . $_GET['file']); ?>"><img alt="Rebuild Thumbnail" src="thumbnail.png" /> <span class="dclick">Rebuild Thumbnail</span></a>&nbsp;</td></tr>
</table>
<table class="max">
	<tr><img alt="x" src="<? echo($wg_public . '/pictures/' . $_GET['file']); ?>"></tr>
</table>
<?php

// End of page
include("footer.php");

?>
