<?php
// Copyright (C) 2001, 2002, 2003 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: weps.php,v 1.23 2003/05/11 23:27:34 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  session_start();

  // Get cookie theme and language variable
  $_SESSION["ses_theme"] = $_COOKIE["weps_theme"];
  $_SESSION["ses_language"] = $_COOKIE["weps_language"];

  if (isset($_POST["new_theme"]))
  {
    $_SESSION["ses_theme"] = $_POST["new_theme"];

    // If we change to a new theme, we still keep current page.
    if ($_SESSION["ses_query_string"] != "")
    {
      header("Location: " . $config["action"]["dispatcher"] . "?" . $_SESSION["ses_query_string"]);

      // Sets cookie theme for 35 years. That should be enough.
      setcookie("weps_theme", $_SESSION["ses_theme"], time() + 3600 * 24 * 365 * 35, "/");

      exit;
    }
  }

  if (!isset($_SESSION["ses_theme"]))
  {
    $_SESSION["ses_theme"] = $config["misc"]["DEFAULT_THEME"];
  }

  // Sets cookie theme for 35 years. That should be enough.
  setcookie("weps_theme", $_SESSION["ses_theme"], time() + 3600 * 24 * 365 * 35, "/");

  // language
  if (isset($_POST["new_language"]))
  {
    $_SESSION["ses_language"] = $_POST["new_language"];

    // If we change to a new language, we still keep current page.
    if ($_SESSION["ses_query_string"] != "")
    {
      header ("Location: " . $config["action"]["dispatcher"] . "?" . $_SESSION["ses_query_string"]);

      // Sets cookie language for 35 years. That should be enough.
      setcookie("weps_language", $_SESSION["ses_language"], time() + 3600 * 24 * 365 * 35, "/");

      exit;
    }
  }

  if (!isset($_SESSION["ses_language"]))
  {
    $_SESSION["ses_language"] = $config["locale"]["LANG"];
  }

  // Sets cookie language for 35 years. That should be enough.
  setcookie("weps_language", $_SESSION["ses_language"], time() + 3600 * 24 * 365 * 35, "/");

  $t = new Template($config["main"]["WEPS_PATH"] . "/themes/" . $_SESSION["ses_theme"]);
  $t->register_var("ses_theme", $_SESSION["ses_theme"]);
  $t->register_var("ses_language", $_SESSION["ses_language"]);

  $t->set_var("HOME_PAGE", $config["main"]["HOME_PAGE"]);
  $t->set_var("HOME_TITLE", $config["main"]["HOME_TITLE"]);
  $t->set_var("SITE_TITLE", $config["main"]["SITE_TITLE"]);

  $t->set_file("MainMenuHandle", $config["main"]["WEPS_PATH"] . "/inc/mainmenu.php");
  $t->parse("MAIN_MENU","MainMenuHandle");

  $t->set_file("SubMenuHandle", $config["main"]["WEPS_PATH"] . "/inc/submenu.php");
  $t->parse("SUB_MENU","SubMenuHandle");

  $t->set_file("QuickSearchHandle", $config["main"]["WEPS_PATH"] . "/inc/quicksearch.php");
  $t->parse("QUICK_SEARCH","QuickSearchHandle");

  $t->set_file("CategoryListHandle", $config["main"]["WEPS_PATH"] . "/inc/categorylist.php");
  $t->parse("CATEGORY_LIST","CategoryListHandle");

  $t->set_file("ThemeListHandle", $config["main"]["WEPS_PATH"] . "/inc/themelist.php");
  $t->parse("THEME_LIST","ThemeListHandle");

  $t->set_file("LanguageListHandle", $config["main"]["WEPS_PATH"] . "/inc/languagelist.php");
  $t->parse("LANGUAGE_LIST","LanguageListHandle");

  // Get the action URL, if action does not exists, go to HOME_PAGE.
  $action = $_GET["action"];
  if (!in_array($action, array_keys($config["action"])))
  {
    $action_url = $config["action"]["home"];
  }
  else
  {
    $t->register_var("action", $action);
    $action_url = $config["action"][$action];

    if (in_array($action, array_keys($config["params"])))
    {
      // Take all parametres in current URL and add them to the template.
      // Just if paramater is in the $config["params"] array.
      $action_params = array();
      $_SESSION["ses_query_string"] = $_SERVER["QUERY_STRING"];
      parse_str($_SESSION["ses_query_string"], $params);
      while (list($key, $val) = each($params))
      {
        if (($key != "action") && (in_array($key, $config["params"][$action])))
        {
          $t->register_var($key, $val);
          $action_params[] = $key;
        }
      }

      //
      // Take parameters coming from a POST or GET.
      //
      // weps.php doesn't know anything about the
      // parameters coming from a form, so all of them
      // must be declared previously. They are saved in
      // the $config["params"] array. Do not edit this array
      // unless you know what you are doing.
      //
      while(list($key, $isarray) = each($config["params"][$action]))
      {
        if (!in_array($key, $action_params) && (isset($_POST[$key]) || isset($_GET[$key])))
        {
          if (isset($_GET[$key])) $t->register_var($key, $_GET[$key]);
          if (isset($_POST[$key])) $t->register_var($key, $_POST[$key]);
        }
      }

      if ($action == "uploadfile")
      {
        include("inc/weps_uploadfile.php");
        $t->register_var("uploadok", $uploadok);
      }
      if ($action == "updatefile")
      {
        include("inc/weps_updatefile.php");
        $t->register_var("uploadok", $uploadok);
      }
    }
  }

  $t->set_file("MainHandle", $config["main"]["WEPS_PATH"] . "/" . $action_url);
  $t->parse("MAIN","MainHandle");

  $t->set_file("FooterHandle", $config["main"]["WEPS_PATH"] . "/inc/footer.php");
  $t->parse("FOOTER","FooterHandle");

  $t->set_file("FullHandle", $_SESSION["ses_theme"] . ".ihtml");
  $t->parse("Output","FullHandle");
  $t->p("Output");

  require("inc/close_env.php");
?>
