<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: search.php,v 1.27 2002/08/30 08:45:03 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Search");
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "search");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <table border="0" width="100%">
        <tr>
          <td>
            <table width="100%" border="0">
              <tr>
                <td width="30%" align="center">
                  <table border="0">
                    <tr>
                      <td><font class="subtitle"><b><?= _my("Select categories:") ?></b></font><br></td>
                    </tr>
                    <tr>
                      <td>
                        <select name="catarray[]" size="7" multiple>
                          <?php
                            $query = $db->exec('select * from category where par_id=-1 order by name');
                            for ($i = 0; $i <$db->numrows($query); $i++)
                            {
                              $obj = $db->fetch_object($query, $i);
                              echo '<option value="' . $obj->id .  '"';
                              if (isset($catarray) && in_array($obj->id, $catarray)) echo ' selected>';
                              else echo '>';
                              echo $obj->name . '</option>';
                            }
                          ?>
                        </select>
                      </td>
                    </tr>
                  </table>
                </td>
                <td align="center">
                  <table border="0" width="100%">
                    <tr>
                      <td align="right"><font class="subtitle"><b><?= _my("Search on:") ?></b></font></td>
                      <td>
                        <input type="checkbox" name="cat" value="1" <?php if (isset($cat)) echo 'checked'; ?>><?= _my("Categories") ?>
                        <input type="checkbox" name="pac" value="1" <?php if (isset($pac)) echo 'checked'; ?>><?= _my("Packages") ?>
                        <input type="checkbox" name="fil" value="1" <?php if (isset($fil)) echo 'checked'; ?>><?= _my("Files") ?>
                      </td>
                    </tr>
                    <tr><td>&nbsp;</td></tr>
                    <tr>
                      <td align="right"><font class="subtitle"><b><?= _my("Name:") ?></b></font></td>
                      <td><input type="text" name="name" value="<?= stripslashes($name) ?>" size="30"></td>
                    </tr>
                    <tr>
                      <td align="right"><font class="subtitle"><b><?= _my("Description:") ?></b></font></td>
                      <td><input type="text" name="description" value="<?= stripslashes($description) ?>" size="30"></td>
                    </tr>
                    <tr><td>&nbsp;</td></tr>
                    <tr>
                      <td>&nbsp;</td>
                      <td align="center">
                        <?php
                          echo '<input type="submit" name="searchButton" value="';
                          echo _my("Search");
                          echo '">' . "\n";
                          echo '<input type="reset" value="';
                          echo _my("Reset");
                          echo '">' . "\n";
                        ?>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
      </form>
      <?php
        if (!isset($catarray))
        {
          $catarray = array();
          $query = $db->exec("select * from category where par_id=-1 order by fullname");
          $numcat = $db->numrows($query);
          for ($i = 0; $i <$numcat; $i++)
          {
            $obj = $db->fetch_object($query, $i);
            $catarray[] = $obj->id;
          }
        }
        if (isset($cat) || isset($pac) || isset($fil))
        {              
          $search_engine = new SearchEngine;
          for ($i = 0; $i < sizeof($catarray); $i++)
          {
            $id = $catarray[$i];
            $parent = "";

            if (isset($cat))
            {
              unset($search);
              $search["fullname"] = $name;
              $search["description"] = $description;
              create_search_category_tree($db, $search_engine, $CATEGORY_SEPARATOR, $id, $parent, $search);
            }
            
            if (isset($pac))
            { 
              unset($catarr);
              $catarr = array();
              if ($id != -1) $catarr[$id] = $parent;
              create_category_tree($db, $catarr, $CATEGORY_SEPARATOR, $id, $parent);
              while (list($key, $val) = each ($catarr))
              {
                $sql = "select * from package where cat_id=$key";
                unset($search);
                $search["name"] = $name;
                $search["description"] = $description;
                $sqlaux = create_sql_search($search);
                if ($sqlaux != "") $sql = $sql . " and ";
                $sql = $sql . $sqlaux;
                
                $search_item = array(
                  "table"  => "1-package",
                  "sql"    => $sql
                );
                $search_engine->add($search_item);
              }
            }
            
            if (isset($fil))
            {
              unset($catarr);
              $catarr = array();
              if ($id != -1) $catarr[$id] = $parent;
              create_category_tree($db, $catarr, $CATEGORY_SEPARATOR, $id, $parent);
              while (list($key, $val) = each ($catarr))
              {
                $query = $db->exec("select * from package where cat_id=$key");
                for ($j = 0; $j < $db->numrows($query); $j++)
                {
                  $obj = $db->fetch_object($query, $j);
                  $sql = "select * from file where pac_id=$obj->id";
                  unset($search);
                  $search["name"] = $name;
                  $search["description"] = $description;
                  $sqlaux = create_sql_search($search);
                  if ($sqlaux != "") $sql = $sql . " and ";
                  $sql = $sql . $sqlaux;
                  $search_item = array(
                    "table"  => "2-file",
                    "sql"    => $sql
                  );
                  $search_engine->add($search_item);
                }
              }
            }
          }
          
          $search_results = $search_engine->exec($db);
          sort($search_results);
          reset($search_results);
          
          echo '<hr><br>' . "\n";
          echo '<b>';
          echo _my("Search results");
          echo '</b>' . "\n";
          echo '<br><br>' . "\n";
          echo '<table width="100%" summary="" border="0">' . "\n";
          echo '  <tr>' . "\n";
          echo '    <td width="50%" valign="top">' . "\n";          

          $n = sizeof($search_results);
          $numpages = ceil($n / $config["misc"]["SEARCH_SCROLL"]);

          if (!isset($page) || ($page <= 0)) $page = 1;
          if ($page > $numpages) $page = $numpages;
          $pos = ($page - 1) * $config["misc"]["SEARCH_SCROLL"];

          echo '<dl>' . "\n";
          for ($i = $pos, $j = 0; ($j < $config["misc"]["SEARCH_SCROLL"]) && ($i < $n); $i++, $j++)
          {
            echo '<dt>';
            switch($search_results[$i]["table"])
            {
              case "0-category":
                echo '[cat] ';
                unset($params);
                $params["parid"] = $search_results[$i]["fields"]["id"];
                $link = create_weps_link($config["action"]["dispatcher"], "subbrowse", $params);
                echo '<a href="' . $link . '" class="link">' . $search_results[$i]["fields"]["fullname"] . '</a>';
                break;
              case "1-package":
                echo '[pac] ';
                unset($params);
                $packid = $search_results[$i]["fields"]["id"];
                $params["packid"] = $packid;
                $link = create_weps_link($config["action"]["dispatcher"], "package", $params);
                $catid = get_field_by_id($db, "package", "cat_id", $packid);
                $catname = get_field_by_id($db, "category", "fullname", $catid);                      
                $aux = $catname . $config["misc"]["CATEGORY_SEPARATOR"] . $search_results[$i]["fields"]["name"];
                echo '<a href="' . $link . '" class="link">' . $aux . '</a>';
                break;
              case "2-file":
                echo '[fil] ';
                
                $fileid = $search_results[$i]["fields"]["id"];
                
                $packid = get_field_by_id($db, "file", "pac_id", $fileid);
                $packname = get_field_by_id($db, "package", "name", $packid);
                
                $catid = get_field_by_id($db, "package", "cat_id", $packid);
                $catname = get_field_by_id($db, "category", "fullname", $catid);
                $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $catname);

                $repfile = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir . "/" . $packname . "/" . $search_results[$i]["fields"]["name"];
                $fsize = get_file_size($repfile);

                $link = $config["path"]["REP_HTML_PATH"] . "/" . $catdir . "/" . $packname . "/" . $search_results[$i]["fields"]["name"];
                $aux = $catname . $config["misc"]["CATEGORY_SEPARATOR"] . $packname . $config["misc"]["CATEGORY_SEPARATOR"] . $search_results[$i]["fields"]["name"];
                echo '<a href="' . $link . '" class="link">' . $aux . '</a> (' . $fsize . ')';
                break;
            }
            echo '<dd>';
            echo $search_results[$i]["fields"]["description"];
            echo '<br><br>';
          }               
          echo '</dl>' . "\n";
          echo '     </font>' . "\n";
          echo '    </td>' . "\n";
          echo '  </tr>' . "\n";
          echo '</table>' . "\n";
          echo '<br>' . "\n";
          echo sprintf(_my("Total: %d match(es) found."), $n);
          echo '<br><br>' . "\n";
          
          $added = false;
          $link = create_weps_link($config["action"]["dispatcher"], "search");
          $link = $link . "&";
          if (isset($cat))
          {
            $link = $link . "cat=1";
            $added = true;
          }
          if (isset($pac))
          {
            if ($added) $link = $link . "&";
            $link = $link . "pac=1";
            $added = true;
          }
          if (isset($fil))
          {
            if ($added) $link = $link . "&";
            $link = $link . "fil=1";
            $added = true;
          }
          if ($name != "") $link = $link . "&name=" . urlencode($name);
          if ($description != "") $link = $link . "&description=" . urlencode($description);
          
          if (!isset($numcat))
          {
            for ($i = 0; $i < sizeof($catarray); $i++)
            {
              $link = $link . "&catarray[$i]=" . $catarray[$i];
            }
          }

          echo '<center>';

          if ($page > 1)
          {
            echo '<a href="' . $link . '" class="link"><b>&lt;&lt;</b></a>';

            echo '&nbsp;&nbsp;&nbsp;';
            $link1 = $link;
            $p = $page - 1;
            if ($p != 1)
            {
              $link1 = $link1 . "&page=$p";
            }
            echo '<a href="' . $link1 . '" class="link"><b>&lt;</b></a>';
          }
          echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
          echo sprintf(_my("Page %d/%d"), $page, $numpages);
          echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
          if ($page < $numpages)
          {
            $p = $page + 1;
            $link2 = $link . "&page=$p";
            echo '<a href="' . $link2 . '" class="link"><b>&gt;</b></a>';

            echo '&nbsp;&nbsp;&nbsp;';
            $link2 = $link . "&page=$numpages";
            echo '<a href="' . $link2 . '" class="link"><b>&gt;&gt;</b></a>';
          }
          echo '</center>';
        }
      ?>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
