<?php
// Copyright (C) 2001, 2002, 2003 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: packfiles.php,v 1.16 2003/05/11 23:36:13 aleix Exp $
?>
<?php
  require_once("config.php");
  require_once("misc.php");
  require_once("database.php");

  $packid = $_POST["packid"];
  $packagetype = $_POST["packagetype"];
  $filecheck = $_POST["filecheck"];

  if (!isset($packid) || !isset($packagetype))
  {
    header ("Location: ". $config["main"]["HOME_PAGE"]);
  }

  // Opens a persistent database connection.
  $db = new Database;
  $db->create($config["database"]["TYPE"]);
  $db->open($config["database"]["HOST"], $config["database"]["PORT"],
            $config["database"]["NAME"], $config["database"]["USER"],
            $config["database"]["PASSWORD"]);

  $catid = get_field_by_id($db, "package", "cat_id", $packid);
  if (($catid != -1) && ($packid != -1))
  {
    $package = get_field_by_id($db, "package", "name", $packid);
    $catname = get_field_by_id($db, "category", "fullname", $catid);
    $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $catname);
    $packdir = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir;
    $packfile = array();
    if (sizeof($filecheck) > 0)
    {
      while (list($key, $val) = each($filecheck))
      {
        $packfile[] = get_field_by_id($db, "file", "name", $key);
      }
    }
    else
    {
      $query = $db->exec("select * from file where pac_id=$packid");
      for ($i = 0; $i < $db->numrows($query); $i++)
      {
        $obj = $db->fetch_object($query, $i);
        $packfile[] = $obj->name;
      }
    }

    $filelist = "";
    for ($i = 0; $i < sizeof($packfile); $i++)
    {
      $filelist .= ' "' . $package . "/" . $packfile[$i] . '"';
    }
    chdir($packdir);
    $filename = $package;
    switch ($packagetype)
    {
      case "targz":
        header("Content-Type: application/x-gtar");
        $filename .= ".tar.gz";
        break;
      case "zip":
        header("Content-Type: application/zip");
        $filename .= ".zip";
        break;
    }

    header("Content-Disposition: inline; filename=\"$filename\"");
    switch ($packagetype)
    {
      case "targz": passthru("tar zc $filelist"); break;
      case   "zip": passthru("zip -q - $filelist"); break;
    }
  }
  else
  {
    header ("Location: " . $config["main"]["HOME_PAGE"]);
  }
?>
