<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: misc.php,v 1.21 2002/08/24 09:59:23 aleix Exp $
?>
<?php
  /////////////////////////////////////////////////////////////////////////////
  // Search realted functions
  /////////////////////////////////////////////////////////////////////////////

  // Creates an sql statement from an array like $array["sql_field"] = values
  // for example:
  //
  // $search["name"] = "c++ dev";
  // $search["description"] = "doc";
  // ...
  // would generate:
  // ((upper(name) like upper('%c++%')) or (upper(name) like upper('%dev%'))) and
  // ((upper(description) like upper('%doc%')))
  function create_sql_search($search)
  {
    $aux = 0;
    $sql = '';
    while (list($key, $val) = each($search))
    {
      if ($val != "")
      {
        $list = explode(" ", $val);
        $n = sizeof($list);
        
        if ($aux > 0) $sql = $sql . " and ";
        if ($n > 0) $sql = $sql . "(";
        for ($i = 0; $i < $n; $i++)
        {
          $sql = $sql . "(upper($key) like upper('%$list[$i]%'))";
          if ($i != ($n - 1)) $sql = $sql . " or ";
        }
        if ($n > 0) $sql = $sql .")";

        $aux++;
      }
    }
    
    return $sql;
  }


  /////////////////////////////////////////////////////////////////////////////
  // Category realted functions
  /////////////////////////////////////////////////////////////////////////////

  // Creates an array of type array[category_id] = category_name
  // from category $parent.
  //
  // Needs variable $catarr declared global.
  function create_category_tree($db, &$catarr, $separator, $parent, $string)
  {
    $query = $db->exec("select * from category where par_id=$parent order by name");
    $straux = $string;
    $n = $db->numrows($query);
    for($i = 0; $i < $db->numrows($query); $i++)
    {
      $obj = $db->fetch_object($query, $i);
      if ($parent > -1) $straux = $straux . $separator;
      $straux = $straux . $obj->name;
      $catarr[$obj->id] = $straux;
      create_category_tree($db, $catarr, $separator, $obj->id, $straux);
      $straux = $string;
    }                             
  }
  
  // Creates an array of category ids like array[] = category_id
  // from category $parent.
  function create_category_tree_id($db, &$catidarr, $parent)
  {
    $query = $db->exec("select * from category where par_id=$parent order by name");
    $n = $db->numrows($query);
    for($i = 0; $i < $db->numrows($query); $i++)
    {
      $obj = $db->fetch_object($query, $i);
      $catidarr[] = $obj->id;
      create_category_tree_id($db, $catidarr, $obj->id);
    }
  }

  function create_search_category_tree($db, &$search_engine, $separator, $parent, $string, $search)
  {
    $sqlaux = create_sql_search($search);

    $par_id = get_field_by_id($db, "category", "par_id", $parent);
    if ($par_id == -1)
    {
      $sql = "select * from category where id=$parent";
      if ($sqlaux != "") $sql = $sql . " and ";
      $sql = $sql . $sqlaux;
      $search_item = array(
        "table"  => "0-category",
        "sql"    => $sql
      );
      $search_engine->add($search_item);
    }

    $sql = "select * from category where par_id=$parent";
    if ($sqlaux != "") $sql = $sql . " and ";
    $sqlaux = create_sql_search($search);
    $sql = $sql . $sqlaux;

    $search_item = array(
      "table"  => "0-category",
      "sql"    => $sql
    );
    $search_engine->add($search_item);

    $query = $db->exec("select * from category where par_id=$parent");
    $straux = $string;
    for($i = 0; $i < $db->numrows($query); $i++)
    {
      $obj = $db->fetch_object($query, $i);
      if ($parent > -1) $straux = $straux . $separator;
      $straux = $straux . $obj->name;
      create_search_category_tree($db, $search_engine, $separator, $obj->id, $straux, $search);
      $straux = $string;
    }
  }

  function count_category_packages($db, $catidarr)
  {
    $sum = 0;
    for ($i = 0; $i < sizeof($catidarr); $i++)
    {
      $query = $db->exec("select count(*) as num from package where cat_id=$catidarr[$i]");
      $obj = $db->fetch_object($query, 0);
      $sum += $obj->num;
    }
    
    return $sum;
  }

  function get_main_category_id_by_field($db, $field, $value)
  {
    $query = $db->exec("select id from category where $field=$value and par_id=-1");
    if ($db->numrows($query) > 0)
    {
      $obj = $db->fetch_object($query, 0);
      return $obj->id;
    } else return -1;
  }

  /////////////////////////////////////////////////////////////////////////////
  // Database tables realted functions
  /////////////////////////////////////////////////////////////////////////////

  function get_id_by_field($db, $table, $field, $value)
  {
    $query = $db->exec("select id from $table where $field='$value'");
    if ($db->numrows($query) > 0)
    {
      $obj = $db->fetch_object($query, 0);
      return $obj->id;
    } else return -1;
  }
  
  function get_id_by_composed_name($db, $table, $value)
  {
    $query = $db->exec("select * from $table");
    for ($i = 0; $i < $db->numrows($query); $i++)
    {
      $obj = $db->fetch_object($query, $i);
      $aux = "$obj->name ($obj->description)";
      if ($aux == $value) return $obj->id;
    }
    return -1;
  }
  
  function get_field_by_id($db, $table, $field, $id)
  {
    $query = $db->exec("select $field as field from $table where id=$id");
    if ($db->numrows($query) > 0)
    {
      $obj = $db->fetch_object($query, 0);
      return $obj->field;
    }
  }

  function count_package_files($db, $id)
  {
    $query = $db->exec("select count(*) as num from file where pac_id=$id");
    $obj = $db->fetch_object($query, 0);
    return $obj->num;
  }
  
  function delete_category($db, $catid, $rep_path, $separator)
  {
    $category = get_field_by_id($db, "category", "fullname", $catid);
    $catdir = $rep_path . "/" . str_replace($separator, "/", $category);

    $query = $db->exec("select * from category where par_id=$catid");
    for ($i = 0; $i < $db->numrows($query); $i++)
    {
      $obj = $db->fetch_object($query, $i);
      delete_category($db, $obj->id, $rep_path, $separator);
    }

    $query = $db->exec("select * from package where cat_id=$catid");
    for ($i = 0; $i < $db->numrows($query); $i++)
    {
      $obj = $db->fetch_object($query, $i);
      delete_package($db, $catid, $obj->id, $rep_path, $separator);
    }

    remove_directory($catdir);
        
    $db->exec("delete from category where id=$catid");
  }

  function delete_package($db, $catid, $packid, $rep_path, $separator)
  {
    $category = get_field_by_id($db, "category", "fullname", $catid);
    $package = get_field_by_id($db, "package", "name", $packid);
    $catdir = $rep_path . "/" . str_replace($separator, "/", $category);
    $packdir = $catdir . "/" . $package;
    remove_directory($packdir);
        
    $db->exec("delete from package where id=$packid");
    $db->exec("delete from file where pac_id=$packid");
  }

  /////////////////////////////////////////////////////////////////////////////
  // File system realted functions
  /////////////////////////////////////////////////////////////////////////////

  // Removes a directory and its files.
  function remove_directory($dir)
  {
    if (@is_dir($dir))
    {
      $handle = @opendir($dir); 
      while (($file = @readdir($handle)))
      { 
        if ($file != "." && $file != "..")
        {
          $file_aux = $dir ."/". $file;
          @unlink($file_aux); 
        }
      }
      @closedir($handle);
      @rmdir($dir);
    }
  }
  
  // Returns a file size string of type: size (MB | KB | B).
  function get_file_size($filename)
  {
    clearstatcache();
    $fsize = @filesize($filename);
    if ($fsize >= 1000000)
    {
      $fsize /= 1000000;
      $s = "MB";
    }
    else
    {
      if ($fsize >= 1000)
      {
        $fsize /= 1000;
        $s = "KB";
      }
      else $s = "B";
    }
    if ($s == "MB") return sprintf("%.1f %s", $fsize, $s);
    else return sprintf("%.0f %s", $fsize, $s);
  }

  /////////////////////////////////////////////////////////////////////////////
  // Language functions
  /////////////////////////////////////////////////////////////////////////////

  function _my($s)
  {
    if (function_exists("bindtextdomain")) return _($s);
    else return $s;
  }

  function set_weps_language($lang, $path)
  {
    if (function_exists("bindtextdomain"))
    {
      putenv("LANG=" . $lang);
      putenv("LC_ALL=" . $lang);
      setlocale(LC_ALL, $lang);
      bindtextdomain("weps", $path);
      textdomain("weps");
    }
  }

  /////////////////////////////////////////////////////////////////////////////
  // Dummy functions
  /////////////////////////////////////////////////////////////////////////////

  function check_id_value($id)
  {
    $b = settype($id, "integer");
    if (!$b || ($id <= 0)) return false;
    else return true;
  }
  
  // Encodes each subdirectory of the given directory using url encode
  // specifications.
  function url_encode_directory($dir)
  {
    $encdir = "";
    $subdir = explode("/", $dir);
    for ($i = 0; $i < sizeof($subdir); $i++)
    {
      if ($i > 0) $encdir = $encdir . "/";
      $encdir = $encdir . rawurlencode($subdir[$i]);
    }
    
    return $encdir;
  }

  // Creates and URL link like: index.html?action=$action&param1=value1&param2=value2
  // from an URL (e.g. index.html) the weps action and an array like:
  //
  // $params["param1"] = value1
  // $params["param2"] = value2
  // ...
  function create_weps_link($url, $action, $params = "")
  {
    $i = 1;
    $link = $url . "?action=$action";
    if ($params != "")
    {
      while (list($key, $val) = each($params))
      {
        if ($i == 0) $link = $link . "?";
        else $link = $link . "&";
        $link = $link . "$key=$val";
        $i++;
      }
    }
    
    return $link;
  }
    
  function invalid_call()
  {
    echo '<br>';
    echo _my("Invalid call to WePS system.");
    exit;
  }
?>
