<?php
// Copyright (C) 2001, 2002, 2003 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: filelisttable.php,v 1.20 2003/05/11 23:36:13 aleix Exp $
?>
<?php
  $package = get_field_by_id($db, "package", "name", $packid);
  $catname = get_field_by_id($db, "category", "fullname", $catid);
  $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $catname);

  $query = $db->exec("select * from file where pac_id=$packid");
  $n = $db->numrows($query);

  if ($n > 0)
  {
    $asc = $_GET["asc"];
    $order = $_GET["order"];
    if (!isset($order)) $order = "file";
    if (!isset($asc)) $asc = 1;

    echo '<font class="separatorsmall">' . "\n";
    unset($params);
    if (isset($catid)) $params["catid"] = $catid;
    if (isset($packid)) $params["packid"] = $packid;
    $params["checkall"] = 1;
    $link = create_weps_link($config["action"]["dispatcher"], $action, $params);
    echo '<a href="' . $link . '" class="filelink">';
    echo _my("Select all");
    echo '</a>&nbsp;|&nbsp;';

    $params["checkall"] = 0;
    $link = create_weps_link($config["action"]["dispatcher"], $action, $params);
    echo '<a href="' . $link . '" class="filelink">';
    echo _my("Unselect all");
    echo '</a>';
    echo '</font>' . "\n";

    unset($params);
    $params["catid"] = $catid;
    $params["packid"] = $packid;
    $baselink = create_weps_link($config["action"]["dispatcher"], $_GET["action"], $params);

    echo '<table border="0" width="100%">' . "\n";
    echo '  <tr class="tabletitle">' . "\n";
    echo '    <td width="2%">&nbsp;</td>' . "\n";

    echo '    <td width="26%">';
    $link = $baselink . "&order=file&asc=" . ($asc == 1 && $order == "file" ? "0" : "1");
    echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("File") . '</a></b>';
    if ($order == "file") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
    echo '    </td>' . "\n";

    echo '    <td width="29%">';
    $link = $baselink . "&order=descr&asc=" . ($asc == 1 && $order == "descr" ? "0" : "1");
    echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Description") . '</a></b>';
    if ($order == "descr") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
    echo '    </td>' . "\n";

    echo '    <td width="11%" align="center">';
    $link = $baselink . "&order=ver&asc=" . ($asc == 1 && $order == "ver" ? "0" : "1");
    echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Version") . '</a></b>';
    if ($order == "ver") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
    echo '    </td>' . "\n";

    echo '    <td width="10%" align="center">';
    $link = $baselink . "&order=size&asc=" . ($asc == 1 && $order == "size" ? "0" : "1");
    echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Size") . '</a></b>';
    if ($order == "size") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
    echo '    </td>' . "\n";

    echo '    <td width="12%">';
    $link = $baselink . "&order=type&asc=" . ($asc == 1 && $order == "type" ? "0" : "1");
    echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Type") . '</a></b>';
    if ($order == "type") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
    echo '    </td>' . "\n";

    echo '    <td  width="10%" align="center">';
    $link = $baselink . "&order=arch&asc=" . ($asc == 1 && $order == "arch" ? "0" : "1");
    echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Arch.") . '</a></b>';
    if ($order == "arch") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
    echo '    </td>' . "\n";
    echo '</tr>' . "\n";
  }

  $encdir = url_encode_directory($catdir);

  $filelist = array();
  for ($i = 0; $i < $n; $i++)
  {
    $obj = $db->fetch_object($query, $i);

    $repfile = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir . "/" . $package . "/" . $obj->name;

    $filelist["id"][$i] = $obj->id;
    $filelist["file"][$i] = $obj->name;
    $filelist["descr"][$i] = $obj->description;
    $filelist["ver"][$i] = $obj->version;
    $filelist["size"][$i] = get_file_size($repfile);
    $filelist["type"][$i] = get_field_by_id($db, "filetype", "name", $obj->typ_id);
    $filelist["arch"][$i] = get_field_by_id($db, "architecture", "name", $obj->arc_id);
  }

  $direction = ($asc == 1 ? SORT_ASC : SORT_DESC);
  switch($order)
  {
    case "file":
        array_multisort($filelist["file"], $direction,
                        $filelist["id"], $filelist["descr"], $filelist["ver"], $filelist["size"], $filelist["type"], $filelist["arch"]);
        break;
    case "descr":
        array_multisort($filelist["descr"], $direction,
                        $filelist["id"], $filelist["file"], $filelist["ver"], $filelist["size"], $filelist["type"], $filelist["arch"]);
        break;
    case "ver":
        array_multisort($filelist["ver"], $direction,
                        $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["size"], $filelist["type"], $filelist["arch"]);
        break;
    case "size":
        array_multisort($filelist["size"], SORT_NUMERIC, $direction,
                        $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["ver"], $filelist["type"], $filelist["arch"]);
        break;
    case "type":
        array_multisort($filelist["type"], $direction,
                        $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["ver"], $filelist["size"], $filelist["arch"]);
        break;
    case "arch":
        array_multisort($filelist["arch"], $direction,
                        $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["ver"], $filelist["size"], $filelist["type"]);
        break;
  }

  for ($i = 0; $i < sizeof($filelist["id"]); $i++)
  {
    $id = $filelist["id"][$i];
    $file = $filelist["file"][$i];
    $description = $filelist["descr"][$i];
    $version = $filelist["ver"][$i];
    $size = $filelist["size"][$i];
    $type = $filelist["type"][$i];
    $arch = $filelist["arch"][$i];

    echo '<tr class="file">' . "\n";

    echo '<td><input type="checkbox" name="filecheck[' . $id . ']" value="check"';
    if ($filecheck[$id] == "check") echo ' checked';
    if ($checkall) echo ' checked';
    echo '></td>';

    $link = $config["path"]["REP_HTML_PATH"] . "/" . $encdir . "/" . rawurlencode($package) . "/" . rawurlencode($file);
    echo '<td>';
    echo '<font class="file">' . "\n";
    echo '<a href="' . $link . '" class="filelink" target="_blank">' . $file . '</a>' . "\n";
    echo '</font>' . "\n";
    echo '</td>' . "\n";

    echo '<td>';
    echo '<font class="file">' . $description . '</font>' . "\n";
    echo '</td>' . "\n";

    echo '<td align="center">';
    echo '<font class="file">' . $version . '</font>' . "\n";
    echo '</td>' . "\n";

    echo '<td align="center">';
    echo '<font class="file">' . $size . '</font>' . "\n";
    echo '</td>' . "\n";

    echo '<td>';
    echo '<font class="file">' . $type . '</font>' . "\n";
    echo '</td>' . "\n";

    echo '<td align="center">';
    echo '<font class="file">' . $arch . '</font>' . "\n";
    echo '</td>' . "\n";
    echo '</tr>' . "\n";
  }
  if ($n > 0)
  {
    echo '</table>'  . "\n";

    echo '<font class="separatorsmall">' . "\n";
    unset($params);
    $params["packid"] = $packid;
    $params["checkall"] = 1;
    $link = create_weps_link($config["action"]["dispatcher"], "package", $params);
    echo '<a href="' . $link . '" class="filelink">';
    echo _my("Select all");
    echo '</a>&nbsp;|&nbsp;';

    $params["checkall"] = 0;
    $link = create_weps_link($config["action"]["dispatcher"], "package", $params);
    echo '<a href="' . $link . '" class="filelink">';
    echo _my("Unselect all");
    echo '</a>';
    echo '</font>' . "\n";
  }

  $sum = $n;
  echo '</p>' . "\n";
  echo '<p>' . "\n";
  echo sprintf(_my("Total: %d file(s) in package."), $sum) . "\n";
  echo '</p>' . "\n";
?>
