<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: database.php,v 1.6 2002/05/19 09:05:19 aleix Exp $
?>
<?php
class Database
{
  var $type;
  var $dbconn;
  var $host, $port, $dbname, $user;
  var $TYPE_PGSQL, $TYPE_MYSQL;
  
  function Database()
  {
    $this->TYPE_PGSQL = "pgsql";
    $this->TYPE_MYSQL = "mysql";
  }

  function create($type)
  {
    $this->type = $type;
  }
  
  function open($host, $port, $dbname, $user, $password)
  {
    $this->host = $host;
    $this->port = $port;
    $this->dbname = $dbname;
    $this->user = $user;

    if (!strcmp($this->type, $this->TYPE_PGSQL))
      $this->dbconn = pg_pconnect("host=$host port=$port dbname=$dbname user=$user password=$password");
    else if (!strcmp($this->type, $this->TYPE_MYSQL))
      $this->dbconn = mysql_pconnect("$host:$port", $user, $password);
    
    if (!$this->dbconn) return false;
    else return true;
  }
  
  function close()
  {
    if (!strcmp($this->type, $this->TYPE_PGSQL))
      return pg_close($this->dbconn);
    else if (!strcmp($this->type, $this->TYPE_MYSQL))
      return mysql_close($this->dbconn);
  }
  
  function exec($sql)
  {
    if (!strcmp($this->type, $this->TYPE_PGSQL))
      return pg_exec($this->dbconn, $sql);
    else if (!strcmp($this->type, $this->TYPE_MYSQL))
      return mysql_db_query($this->dbname, $sql, $this->dbconn);
  }
  
  function numrows($query)
  {
    if (!strcmp($this->type, $this->TYPE_PGSQL))
      return pg_numrows($query);
    else if (!strcmp($this->type, $this->TYPE_MYSQL))
      return mysql_num_rows($query);
  }
  
  function fetch_array($query, $row)
  {
    if (!strcmp($this->type, $this->TYPE_PGSQL))
      return pg_fetch_array($query, $row);
    else if (!strcmp($this->type, $this->TYPE_MYSQL)) {
      mysql_data_seek($query, $row);
      return mysql_fetch_array($query);
    }
  }

  function fetch_object($query, $row)
  {
    if (!strcmp($this->type, $this->TYPE_PGSQL))
      return pg_fetch_object($query, $row);
    else if (!strcmp($this->type, $this->TYPE_MYSQL)) {
      mysql_data_seek($query, $row);
      return mysql_fetch_object($query);
    }
  }
  
  function get_lastid($query, $table, $field)
  {
    if (!strcmp($this->type, $this->TYPE_PGSQL))
    {
      $oid = pg_getlastoid($query);
      $qaux = pg_exec("select $field from $table where oid=$oid");
      $arr = pg_fetch_array($qaux, 0);
      return $arr[$field];
    }
  }
}
?>
