<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: uploadfile.php,v 1.22 2002/08/24 10:01:28 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Upload file");

  if (!isset($catid) || !isset($packid)) invalid_call();  
  if (!check_id_value($catid) || !check_id_value($packid)) invalid_call();

  $category = get_field_by_id($db, "category", "fullname", $catid);
  $package = get_field_by_id($db, "package", "name", $packid);

  $addOK = false;
  $errorFound = false;
  if (isset($uploadButton))
  {
    if (($arch != "") && ($ftype != ""))
    {
      $archid = get_id_by_composed_name($db, "architecture", $arch);
      $typid = get_id_by_composed_name($db, "filetype", $ftype);
      if (($archid != -1) && ($typid != -1))
      {
        if (($version != "") && ($description != ""))
        {
          if  ($uploadok)
          {
            $addOK = true;
            $description = "";
            $version = "";
            $arch = "";
            $ftype = "";
            $lastMsg = _my("New file successfully added.");
          }
          else
          {
            $errorFound = true;
            $query = $db->exec("select * from file where name='$myfile_name' and pac_id=$packid");
            if ($db->numrows($query) > 0) $lastMsg = _my("Sorry, but this file already exist.");
            else $lastMsg = _my("There was a problem uploading the file.");
          }
        }
        if (!$errorFound && !$addOK)
        {
          $errorFound = true;
          $lastMsg = _my("Some of the input fields are wrong.");
        }
      }
      if (!$errorFound && ($archid == -1))
      {
        $errorFound = true;
        $lastMsg = _my("You must select an architecture first.");
      }
      if (!$errorFound && ($typid == -1))
      {
        $errorFound = true;
        $lastMsg = _my("You must select a file type first.");
      }
    }
  }

  $description = stripslashes($description);
  $version = stripslashes($version);
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "uploadfile");
      ?>
      <form name="form1" method="post" action="<?= $link ?>" enctype="multipart/form-data">
      <input type="hidden" name="catid" value="<?= $catid ?>">
      <input type="hidden" name="packid" value="<?= $packid ?>">
      <table border="0">
        <tr>
          <td>
            <table width="100%" border="0">
              <tr>
                <td width="20%" align="right"><?= _my("Package:") ?></td>
                <td>
                  <select>
                    <?php
                      $desc = get_field_by_id($db, "package", "description", $packid);
                      echo "<option>$package ($desc)</option>";
                    ?>
                  </select>
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Architecture:") ?></td>
                <td>
                  <select name="arch">
                    <option value="-1"><?= _my("---------------------- Choose an item below ----------------------") ?></option>
                    <?php
                      $query = $db->exec("select * from architecture order by name");
                      for($i = 0; $i < $db->numrows($query); $i++)
                      {
                        $obj = $db->fetch_object($query, $i);
                        $aux = "$obj->name ($obj->description)";
                        if ($aux == $arch) echo "<option selected>";
                        else echo "<option>";
                        echo "$obj->name ($obj->description)</option>\n";
                      }
                    ?>
                  </select>
                </td>
              </tr>
              <tr><td>&nbsp;</td></tr>
              <tr>
                <td width="20%" align="right"><?= _my("File type:") ?></td>
                <td>
                  <select name="ftype">
                    <option value="-1"><?= _my("---------------------- Choose an item below ----------------------") ?></option>
                    <?php
                      $query = $db->exec("select * from filetype order by name");
                      for($i = 0; $i < $db->numrows($query); $i++)
                      {
                        $obj = $db->fetch_object($query, $i);
                        $aux = "$obj->name ($obj->description)";
                        if ($aux == $ftype) echo "<option selected>";
                        else echo "<option>";
                        echo "$obj->name ($obj->description)</option>\n";
                      }
                    ?>
                  </select>
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("File:") ?></td>
                <td>
                  <input type="hidden" name="MAX_FILE_SIZE" value="<?= $config["misc"]["MAX_FILE_SIZE"] ?>">
                  <input type="file" name="myfile" value="Browse..." size="53">
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Description:") ?></td>
                <td>
                  <input type="text" name="description" value="<?= $description ?>" size="53">
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Version:") ?></td>
                <td>
                  <input type="text" name="version" value="<?= $version ?>" size="10">
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td align="center">
            <?php
              echo '<input type="submit" name="uploadButton" value="';
              echo _my("Upload");
              echo '">' . "\n";
              echo '<input type="reset" value="';
              echo _my("Reset");
              echo '">' . "\n";
            ?>
          </td>
        </tr>
        <?php
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
      <form name="fileform" method="post" action="inc/packfiles.php">
      <?php
        echo '<p>' . "\n";
        echo '<font class="subtitle">' . "\n";
        echo '  <b>';
        echo _my("Current file(s) in package:");
        echo '</b>' . "\n";
        echo '</font>' . "\n";
        require("inc/filelist.php");
        echo '</p>' . "\n";
      ?>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
