<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: updatepackage.php,v 1.20 2002/08/24 10:01:27 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Update package");
  
  if (!isset($catid) || !isset($packid)) invalid_call();
  if (!check_id_value($catid) || !check_id_value($packid)) invalid_call();

  $category = get_field_by_id($db, "category", "fullname", $catid);
  $package = get_field_by_id($db, "package", "name", $packid);

  $errorFound = false;
  if (isset($name) && isset($description))
  {
    if (($name != "") && ($description != ""))
    {
      $db->exec("update package set name='$name',description='$description' where id=$packid");

      $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $category);
      $olddir = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir . "/" . $package;
      $newdir = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir . "/" . $name;
      rename($olddir, $newdir);

      // Package name is set to new name
      $package = $name;
      
      $lastMsg = _my("Package successfully updated.");
    }
    else
    {
      $errorFound = true;
      $lastMsg = _my("Input fields should not be empty.");
    }
  }
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "updatepackage");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <input type="hidden" name="catid" value="<?= $catid ?>">
      <input type="hidden" name="packid" value="<?= $packid ?>">
      <table border="0">    
        <tr>
          <td>
            <font class="subtitle">
              <b>
              <?php
                echo _my("Updating package:");
                echo "&nbsp;";
                unset($params);
                $params["packid"] = $packid;
                $link = create_weps_link($config["action"]["dispatcher"], "package", $params);
                echo '<a href="' . $link . '" class="link">';
                echo $category . $config["misc"]["CATEGORY_SEPARATOR"] . $package;
                echo '</a>';
              ?>
              </b>
            </font>
            <p>
            <table width="100%" border="0">
              <tr>
                <td width="20%" align="right"><?= _my("Name:") ?></td>
                <td>
                  <input type="text" name="name" value="<?= $package ?>" size="53">
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Description:") ?></td>
                <td>
                  <?php
                    $description = get_field_by_id($db, "package", "description", $packid);
                  ?>
                  <input type="text" name="description" value="<?= $description ?>" size="53">
                </td>
              </tr>
            </table>
            </p>
          </td>
        </tr>
        <tr>
          <td align="center">
            <?php
              echo '<input type="submit" name="updateButton" value="';
              echo _my("Update");
              echo '">' . "\n";
              echo '<input type="reset" value="';
              echo _my("Reset");
              echo '">' . "\n";
            ?>
          </td>
        </tr>
        <?php
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
      <form name="fileform" method="post" action="<?= $config["main"]["HOME_PAGE"] ?>/inc/packfiles.php">
      <?php
        echo '<p>' . "\n";
        echo '<font class="subtitle">' . "\n";
        echo '  <b>';
        echo _my("Current file(s) in package:");
        echo '</b>' . "\n";
        echo '</font>' . "\n";
        require("inc/filelist.php");
        echo '</p>' . "\n";
      ?>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
