<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: updatefile.php,v 1.25 2002/10/23 22:22:36 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Update file");

  if (!isset($catid) || !isset($packid)) invalid_call();
  if (!check_id_value($catid) || !check_id_value($packid)) invalid_call();

  $category = get_field_by_id($db, "category", "fullname", $catid);
  $package = get_field_by_id($db, "package", "name", $packid);

  $errorFound = false;
  if (isset($updateButton))
  {
    if ((sizeof($description) > 0) && (sizeof($version) > 0) && (sizeof($ftype) > 0) && (sizeof($arch) > 0))
    {
      while (list($key, $val) = each($description))
      {
        $desc = $val;
        $ver = $version[$key];
        $typid = $ftype[$key];
        $archid = $arch[$key];
        
        if (($desc == "") || ($ver == "") || ($typid == "") || ($archid == ""))
        {
          $errorFound = true;
          $lastMsg = _my("Some of the input fields are wrong.");
          break;
        }
        if (!errorFound && ($myfile_name[$key] != "") && !uploadok)
        {
          $errorFound = true;
          $lastMsg = _my("Unable to upload files.");
          break;
        }
      }
      if (!$errorFound)
      {
        $lastMsg = _my("File(s) successfully updated.");
      }
    }
  }
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "updatefile");
      ?>
      <form name="form1" method="post" action="<?= $link ?>" enctype="multipart/form-data">
      <input type="hidden" name="catid" value="<?= $catid ?>">
      <input type="hidden" name="packid" value="<?= $packid ?>">
      <?php
        if (($catid != -1) && ($packid != -1))
        {
          echo '<p>' . "\n";
          echo '<font class="subtitle">' . "\n";
          unset($params);
          $params["packid"] = $packid;
          $link = create_weps_link($config["action"]["dispatcher"], "package", $params);
          echo '  <b>';
          echo _my("Current file(s) in package:");
          echo '</b> <a href="' . $link . '" class="link">' . $category . $config["misc"]["CATEGORY_SEPARATOR"] . $package . '</a>' . "\n";
          echo '</font><br><br>' . "\n";
      
          $catname = get_field_by_id($db, "category", "fullname", $catid);
          $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $catname);
      
          $query = $db->exec("select * from file where pac_id=$packid order by version desc,name");
          $n = $db->numrows($query);
          if ($n > 0)
          {
            $asc = $_GET["asc"];
            $order = $_GET["order"];
            if (!isset($order)) $order = "file";
            if (!isset($asc)) $asc = 1;

            unset($params);
            $params["catid"] = $catid;
            $params["packid"] = $packid;
            $baselink = create_weps_link($config["action"]["dispatcher"], $_GET["action"], $params);
            
            echo '<table border="0" width="100%">' . "\n";
            echo '  <tr class="tabletitle">' . "\n";      
            echo '    <td width="28%">';
            $link = $baselink . "&order=file&asc=" . ($asc == 1 && $order == "file" ? "0" : "1");
            echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("File") . '</a></b>';
            if ($order == "file") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
            echo '    </td>' . "\n";
        
            echo '    <td width="20%">';
            $link = $baselink . "&order=descr&asc=" . ($asc == 1 && $order == "descr" ? "0" : "1");
            echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Description") . '</a></b>';
            if ($order == "descr") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
            echo '    </td>' . "\n";
        
            echo '    <td width="10%" align="center">';
            $link = $baselink . "&order=ver&asc=" . ($asc == 1 && $order == "ver" ? "0" : "1");
            echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Version") . '</a></b>';
            if ($order == "ver") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
            echo '    </td>' . "\n";
        
            echo '    <td width="12%">';
            $link = $baselink . "&order=type&asc=" . ($asc == 1 && $order == "type" ? "0" : "1");
            echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Type") . '</a></b>';
            if ($order == "type") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
            echo '    </td>' . "\n";
        
            echo '    <td  width="10%" align="center">';
            $link = $baselink . "&order=arch&asc=" . ($asc == 1 && $order == "arch" ? "0" : "1");
            echo '<b><a href="' . $link . '" class="tabletitlelink">' . _my("Arch.") . '</a></b>';
            if ($order == "arch") echo '&nbsp;<img src="img/' . ($asc == 1 ? "sort_dn.png" : "sort_up.png") . '">';
            echo '    </td>' . "\n";
            echo '</tr>' . "\n";
          }

          $filelist = array();
          for ($i = 0; $i < $n; $i++)
          {
            $obj = $db->fetch_object($query, $i);
        
            $filelist["id"][$i] = $obj->id;
            $filelist["file"][$i] = $obj->name;
            $filelist["descr"][$i] = $obj->description;
            $filelist["ver"][$i] = $obj->version;
            $filelist["type"][$i] = get_field_by_id($db, "filetype", "name", $obj->typ_id);
            $filelist["arch"][$i] = get_field_by_id($db, "architecture", "name", $obj->arc_id);
            $filelist["type_id"][$i] = $obj->typ_id;
            $filelist["arch_id"][$i] = $obj->arc_id;
          }
        
          $direction = ($asc == 1 ? SORT_ASC : SORT_DESC);
          switch($order)
          {
            case "file":
                array_multisort($filelist["file"], $direction,
                                $filelist["id"], $filelist["descr"], $filelist["ver"], $filelist["type"], $filelist["arch"],
                                $filelist["type_id"], $filelist["arch_id"]);
                break;
            case "descr":
                array_multisort($filelist["descr"], $direction,
                                $filelist["id"], $filelist["file"], $filelist["ver"], $filelist["type"], $filelist["arch"],
                                $filelist["type_id"], $filelist["arch_id"]);
                break;
            case "ver":
                array_multisort($filelist["ver"], $direction,
                                $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["type"], $filelist["arch"],
                                $filelist["type_id"], $filelist["arch_id"]);
                break;
            case "type":
                array_multisort($filelist["type"], $direction,
                                $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["ver"], $filelist["arch"],
                                $filelist["type_id"], $filelist["arch_id"]);
                break;
            case "arch":
                array_multisort($filelist["arch"], $direction,
                                $filelist["id"], $filelist["file"], $filelist["descr"], $filelist["ver"], $filelist["type"],
                                $filelist["type_id"], $filelist["arch_id"]);
                break;
          }

          for ($i = 0; $i < sizeof($filelist["id"]); $i++)
          {
            $id = $filelist["id"][$i];
            $file = $filelist["file"][$i];
            $description = $filelist["descr"][$i];
            $version = $filelist["ver"][$i];
            $type = $filelist["type"][$i];
            $arch = $filelist["arch"][$i];
            $type_id = $filelist["type_id"][$i];
            $arch_id = $filelist["arch_id"][$i];

            $link = $config["path"]["REP_HTML_PATH"] . "/" . $catdir . "/" . $package . "/" . $file;
            $repfile = $config["path"]["REPOSITORY_PATH"]. "/" . $catdir . "/" . $packname . "/" . $file;
            
            echo '<tr class="file">' . "\n";
      
            echo '<td>' . "\n";
            echo '<a href="' . $link . '" class="filelink">' . $file . '</a>' . "\n";
            echo '</td>' . "\n";
      
            echo '<td>' . "\n";
            echo '<font class="smaller">' . "\n";
            echo '<input type="text" name="description[' . $id . ']" value="' . $description . '" size="19">' . "\n";
            echo '</font>' . "\n";
            echo '</td>' . "\n";
      
            echo '<td align=\"center\">' . "\n";
            echo '<font class="smaller">' . "\n";
            echo '<input type="text" name="version[' . $id . ']" value="' . $version . '" size="8">' . "\n";
            echo '</font>' . "\n";
            echo '</td>' . "\n";
      
            echo '<td>' . "\n";
            echo '<select name="ftype[' . $id . ']">' . "\n";
            $qaux = $db->exec("select * from filetype order by name");
            for ($j = 0; $j < $db->numrows($qaux); $j++)
            {
              $oaux = $db->fetch_object($qaux, $j);
              echo '<option value="' . $oaux->id . '"';
              if ($oaux->id == $type_id) echo ' selected>';
              else echo '>';
              echo $oaux->name . '</option>' . "\n";
            }
            echo '</select>' . "\n";
            echo '</td>' . "\n";
      
            echo '<td align="center">' . "\n";
            echo '<select name="arch[' . $id . ']">' . "\n";
            $qaux = $db->exec("select * from architecture order by name");
            for ($j = 0; $j < $db->numrows($qaux); $j++)
            {
              $oaux = $db->fetch_object($qaux, $j);
              echo '<option value="' . $oaux->id . '"';
              if ($oaux->id == $arch_id) echo ' selected>';
              else echo '>';
              echo $oaux->name . '</option>' . "\n";
            }
            echo '</select>' . "\n";
            echo '</td>' . "\n";

            echo '</tr>' . "\n";
          }
          if ($n > 0) echo '</table><br>' . "\n";

          if ($n > 0)
          {
            echo '<table border="0" width="100%">' . "\n";
            echo '  <tr class="tabletitle">' . "\n";
            echo '    <td width="28%"><b><font class="tabletitle">';
            echo _my("File");
            echo '</font></b></td>' . "\n";
            echo '    <td width="72%"><b><font class="tabletitle">';
            echo _my("New file");
            echo '</font></b></td>' . "\n";
            echo '</tr>' . "\n";
          }

          for ($i = 0; $i < sizeof($filelist["id"]); $i++)
          {
            $id = $filelist["id"][$i];
            $file = $filelist["file"][$i];

            $link = $config["path"]["REP_HTML_PATH"] . "/" . $catdir . "/" . $package . "/" . $file;
            
            echo '<tr class="file">' . "\n";
      
            echo '<td>' . "\n";
            echo '<a href="' . $link . '" class="filelink">' . $file . '</a>' . "\n";
            echo '</td>' . "\n";
      
            echo '<td>' . "\n";
            echo '<font class="smaller">' . "\n";
            echo '<input type="hidden" name="MAX_FILE_SIZE" value="' . $config["misc"]["MAX_FILE_SIZE"] . '">' . "\n";
            echo '<input type="file" name="myfile[' . $id . ']" size="44">' . "\n";
            echo '</font>' . "\n";
            echo '</td>' . "\n";

            echo '</tr>' . "\n";
          }
          if ($n > 0) echo '</table>' . "\n";

          $sum = $n;
          echo '</p>' . "\n";
          echo '<p>' . "\n";
          echo sprintf(_my("Total: %d file(s) in package."), $sum) . "\n";
          echo '</p>' . "\n";
        }
      ?>
      <table border="0" width="100%">    
        <?php
          if ($n > 0)
          {
            echo '<tr>' . "\n";
            echo '<td align="center">' . "\n";
            echo '  <input type="submit" name="updateButton" value="';
            echo _my("Update");
            echo '">' . "\n";
            echo '  <input type="reset" value="';
            echo _my("Reset");
            echo '">' . "\n";
            echo '</td>' . "\n";
            echo '</tr>' . "\n";
          }

          echo '<tr><td>&nbsp;</td></tr>' . "\n";
          echo '<tr>' . "\n";
          echo '    <td align="right">' . "\n";
          echo '      <font class="separator">' . "\n";
        
          unset($params);
          $params["catid"] = $catid;
          $params["packid"] = $packid;
        
          $link = create_weps_link($config["action"]["dispatcher"], "uploadfile", $params);
          echo '<a href="' . $link . '" class="link">';
          echo _my("Add files");
          echo '</a>&nbsp;|&nbsp;' . "\n";
        
          $link = create_weps_link($config["action"]["dispatcher"], "updatefile", $params);
          echo '<a href="' . $link . '" class="link">';
          echo _my("Update files");
          echo '</a>&nbsp;|&nbsp;' . "\n";
        
          $link = create_weps_link($config["action"]["dispatcher"], "deletefile", $params);
          echo '<a href="' . $link . '" class="link">';
          echo _my("Delete files");
          echo '</a>' . "\n";
        
          echo '      </font>' . "\n";
          echo '    </td>' . "\n";
          echo '</tr>' . "\n";

          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
