<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: updatecategory.php,v 1.18 2002/08/24 10:01:26 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Update category");

  if (!isset($catid)) invalid_call();
  if (!check_id_value($catid)) invalid_call();

  $category = get_field_by_id($db, "category", "fullname", $catid);

  $errorFound = false;
  if (isset($name) && isset($description))
  {
    if (($name != "" ) && ($description != ""))
    {
      $newfullname = "";
      $oldfullname = $category;
      $catarr = explode($config["misc"]["CATEGORY_SEPARATOR"], $category);
      for ($i = 0; $i < sizeof($catarr) - 1; $i++)
      {
        $newfullname .= $catarr[$i] . $config["misc"]["CATEGORY_SEPARATOR"];
      }
      $newfullname .= $name;
      
      $db->exec("update category set name='$name', description='$description', fullname='$newfullname' where id=$catid");
      
      $catidarr = array();
      create_category_tree_id($db, $catidarr, $catid);
      for ($i = 0; $i < sizeof($catidarr); $i++)
      {
        $oldfname = get_field_by_id($db, "category", "fullname", $catidarr[$i]);
        $newfname = $newfullname . substr($oldfname, strlen($oldfullname));
        $db->exec("update category set fullname='$newfname' where id=$catidarr[$i]");
      }      

      $oldcat = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $oldfullname);
      $newcat = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $newfullname);
      
      $olddir = $config["path"]["REPOSITORY_PATH"] . "/" . $oldcat;
      $newdir = $config["path"]["REPOSITORY_PATH"] . "/" . $newcat;      
      rename($olddir, $newdir);

      // Category name is set to new name
      $category = $newfullname;

      $lastMsg = _my("Category successfully updated.");
    }
    else
    {
      $errorFound = true;
      $lastMsg = _my("Input fields should not be empty.");
    }
  }
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "updatecategory");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <input type="hidden" name="catid" value="<?= $catid ?>">
      <table border="0">    
        <tr>
          <td>
            <font class="subtitle">
              <b>              
              <?php
                echo _my("Updating category:");
                echo "&nbsp;";
                unset($params);
                $params["parid"] = $catid;
                $link = create_weps_link($config["action"]["dispatcher"], "subbrowse", $params);
                echo '<a href="' . $link . '" class="link"> ' . $category . '</a>';
              ?>
              </b>
            </font>
            <p>
            <table width="100%" border="0">
              <tr>
                <td width="20%" align="right"><?= _my("Name:") ?></td>
                <td>
                  <?php
                    $name = get_field_by_id($db, "category", "name", $catid);
                  ?>
                  <input type="text" name="name" value="<?= $name ?>" size="53">
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Description:") ?></td>
                <td>
                  <?php
                    $description = get_field_by_id($db, "category", "description", $catid);
                  ?>
                  <input type="text" name="description" value="<?= $description ?>" size="53">
                </td>
              </tr>
            </table>
            </p>
          </td>
        </tr>
        <tr>
          <td align="center">
            <?php
              echo '<input type="submit" name="updateButton" value="';
              echo _my("Update");
              echo '">' . "\n";
              echo '<input type="reset" value="';
              echo _my("Reset");
              echo '">' . "\n";
            ?>
          </td>
        </tr>
        <?php
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
