<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: newpackage.php,v 1.22 2002/08/24 10:01:26 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Create new package");

  $addOK = false;
  if (isset($createButton))
  {
    if (check_id_value($catid))
    {
      $addFound = false;
      $errorFound = false;
      if (($name != "") && ($description != ""))
      {
        $query = $db->exec("select * from category where upper(name)=upper('$name') and par_id=$catid");
        if ($db->numrows($query) > 0) $addFound = true;
  
        $query = $db->exec("select * from package where upper(name)=upper('$name') and cat_id=$catid");
        if ($db->numrows($query) > 0) $addFound = true;

        if (!$addFound)
        {
          $db->exec("insert into package (name, description, cat_id) values ('$name', '$description', $catid)");
          
          $category = get_field_by_id($db, "category", "fullname", $catid);
          $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $category);
          $dir = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir . "/" . stripslashes($name);
          
          if (!@is_dir($dir)) @mkdir($dir, 0755);

          // get package id for upload page (next)
          $query = $db->exec("select * from package where upper(name)=upper('$name') and cat_id=$catid");
          $obj = $db->fetch_object($query, 0);
          $packid = $obj->id;
          $package = stripslashes($name);
          
          $name = "";
          $description = "";
          $lastMsg = _my("New package successfully added.");

          $addOK = true;
        }
        else
        {
          $errorFound = true;
          $lastMsg = _my("Sorry, but there is already a category or package with this name.");
        }
      }
      else
      {
        $errorFound = true;
        $lastMsg = _my("Some of the input fields are wrong.");
      }
    }
    else
    {
      $errorFound = true;
      $lastMsg = _my("You must select a category first.");
    }
  }

  $name = stripslashes($name);
  $description = stripslashes($description);
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "newpackage");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <table border="0">
        <tr>
          <td>
            <table width="100%" border="0">
              <tr>
                <td align="right"><?= _my("Category:") ?></td>
                <td>
                <select name="catid">
                  <option value="-1"><?= _my("---------------------- Choose an item below ----------------------") ?></option>
                  <?php
                    $query = $db->exec("select * from category order by fullname");
                    for ($i = 0; $i < $db->numrows($query); $i++)
                    {
                      $obj = $db->fetch_object($query, $i);
                      echo '<option value="' . $obj->id . '"';
                      if ($catid == $obj->id) echo ' selected>';
                      else echo '>';
                      echo $obj->fullname . '</option>' . "\n";
                    }
                  ?>
                </select>
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Name:") ?></td>
                <td>
                  <input type="text" name="name" value="<?= $name ?>" size="53">
                </td>
              </tr>
              <tr>
                <td width="20%" align="right"><?= _my("Description:") ?></td>
                <td>
                  <input type="text" name="description" value="<?= $description ?>" size="53">
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td align="center">
            <?php
              echo '<input type="submit" name="createButton" value="';
              echo _my("Create");
              echo '">' . "\n";
              echo '<input type="reset" value="';
              echo _my("Reset");
              echo '">' . "\n";
            ?>
          </td>
        </tr>
        <?php
          if ($addOK)
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td align="right">' . "\n";
            unset($params);
            $params["catid"] = $catid;
            $params["packid"] = $packid;
            $link = create_weps_link($config["action"]["dispatcher"], "uploadfile", $params);
            echo '<font size="2" face="Verdana, Arial, Helvetica, sans-serif">';
            echo '    <a href="' . $link . '" class="link">';
            echo _my("Upload files for package:");
            echo ' ' . $package . '</a>' . "\n";
            echo '</font>';
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
