<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: newcategory.php,v 1.21 2002/08/24 10:01:26 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Create new category");

  $addOK = false;
  if (isset($createButton))
  {
    $addFound = false;
    $errorFound = false;
    if (($name != "") && ($description != ""))
    {
      if (check_id_value($catid))
      {
        $category = get_field_by_id($db, "category", "fullname", $catid);
        $fullname = $category . $config["misc"]["CATEGORY_SEPARATOR"] . $name;
      }
      else
      {
        $catid = -1;
        $fullname = $name;
      }
            
      $query = $db->exec("select * from category where upper(name)=upper('$name') and par_id=$catid");
      if ($db->numrows($query) > 0) $addFound = true;

      $query = $db->exec("select * from package where upper(name)=upper('$name') and cat_id=$catid");
      if ($db->numrows($query) > 0) $addFound = true;

      if (!$addFound)
      {
        $db->exec("insert into category (name, description, fullname, par_id) values ('$name', '$description', '$fullname', $catid)");
        $dir = $config["path"]["REPOSITORY_PATH"] . "/" . str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", stripslashes($fullname));
        @mkdir($dir, 0755);
  
        $newCategory = $name;
        $newCatId = get_id_by_field($db, "category", "fullname", $fullname);
        
        $name = "";
        $description = "";

        $lastMsg = _my("New category successfully added.");

        $addOK = true;
      }
      else
      {
        $errorFound = true;
        $lastMsg = _my("Sorry, but there is already a category or package with this name.");
      }
    }
    else
    {
      $errorFound = true;
      $lastMsg = _my("Some of the input fields are wrong.");
    }
  }

  $name = stripslashes($name);
  $description = stripslashes($description);
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "newcategory");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <table border="0">    
        <tr>
          <td>
            <table width="100%" border="0">
              <tr>
                <td align="right"><?= _my("Category:") ?></td>
                <td>
                  <select name="catid">
                    <option value="-1"><?= _my("---------------------- Choose an item below ----------------------") ?></option>
                    <?php
                      $query = $db->exec("select * from category order by fullname");
                      for ($i = 0; $i < $db->numrows($query); $i++)
                      {
                        $obj = $db->fetch_object($query, $i);
                        echo '<option value="' . $obj->id . '"';
                        if ($catid == $obj->id) echo ' selected>';
                        else echo '>';
                        echo $obj->fullname . '</option>' . "\n";
                      }
                    ?>
                  </select>
                </td>
              </tr>
              <tr align="left" valign="middle">
                <td width="20%" align="right"><?= _my("Name:") ?></td>
                <td>
                  <input type="text" name="name" value="<?= $name ?>" size="53">
                </td>
              </tr>
              <tr align="left" valign="middle">
                <td width="20%" align="right"><?= _my("Description:") ?></td>
                <td>
                  <input type="text" name="description" value="<?= $description ?>" size="53">
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td align="center">
            <?php
              echo '<input type="submit" name="createButton" value="';
              echo _my("Create");
              echo '">' . "\n";
              echo '<input type="reset" value="';
              echo _my("Reset");
              echo '">' . "\n";
            ?>
          </td>
        </tr>
        <?php
          if ($addOK)
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td align="right">' . "\n";
            unset($params);
            $params["catid"] = $newCatId;
            $link = create_weps_link($config["action"]["dispatcher"], "newpackage", $params);
            echo '<font size="2" face="Verdana, Arial, Helvetica, sans-serif">';
            echo '    <a href="' . $link . '" class="link">';
            echo _my("Create new package for category:");
            echo ' ' . $newCategory . '</a>' . "\n";
            echo '</font>';
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
