<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: deletefiletype.php,v 1.19 2002/08/24 10:01:25 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Delete file type");

  $errorFound = false;
  if (isset($deleteButton))
  {
    if (check_id_value($ftypeid))
    {
      if (isset($forcedelete))
      {
        $query = $db->exec("select * from file where typ_id=$ftypeid");
        if ($db->numrows($query) == 0)
        {
          $db->exec("delete from filetype where id=$ftypeid");

          $lastMsg = _my("File type successfully deleted.");
        }
        else
        {
          $errorFound = true;
          $lastMsg = _my("Unable to delete file type which is used in installed files.");
        }
      }
      else
      {
        $errorFound = true;
        $lastMsg = _my("File type not deleted. Are you sure you want to delete it?");
      }
    }
    else
    {
      $errorFound = true;
      $lastMsg = _my("You should select a file type first.");
    }
  }
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "deletefiletype");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <table border="0">    
        <tr>
          <td>
            <font class="subtitle">
              <b><?= _my("Select a file type to delete below:") ?></b>
            </font>
            <table width="100%" border="0">
              <tr>
                <td>  
                  <select name="ftypeid">
                    <option value="-1"><?= _my("---------------------- Choose an item below ----------------------") ?></option>
                    <?php
                      $query = $db->exec("select * from filetype order by name");
                      for ($i = 0; $i < $db->numrows($query); $i++)
                      {
                        $obj = $db->fetch_object($query, $i);
                        echo '<option value="' . $obj->id . '"';
                        if ($ftypeid == $obj->id) echo ' selected>';
                        else echo '>';
                        echo $obj->name . ' (' . $obj->description . ')</option>' . "\n";
                      }
                    ?>
                  </select>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td align="center">
            <?php
              echo '<input type="submit" name="deleteButton" value="';
              echo _my("Delete");
              echo '">' . "\n";
            ?>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <input type="checkbox" name="forcedelete" value="check">
            <?= _my("I'm sure") ?>
          </td>
        </tr>
        <?php
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
