<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
// $Id: deletefile.php,v 1.22 2002/08/24 10:01:24 aleix Exp $
?>
<?php
  require("inc/init_env.php");

  $TITLE = _my("Delete files");

  if (!isset($catid) || !isset($packid)) invalid_call();
  if (!check_id_value($catid) || !check_id_value($packid)) invalid_call();

  $category = get_field_by_id($db, "category", "fullname", $catid);
  $package = get_field_by_id($db, "package", "name", $packid);

  $errorFound = false;
  if (isset($deleteButton))
  {
    if (sizeof($filecheck) > 0)
    {
      if (isset($forcedelete))
      {        
        $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $category);
        while (list($key, $val) = each($filecheck))
        {
          $filename = get_field_by_id($db, "file", "name", $key);
          $repfile = $config["path"]["REPOSITORY_PATH"] . "/" . $catdir . "/" . $package . "/" . $filename;          
          @unlink($repfile);
          $db->exec("delete from file where id=$key");
        }
        $lastMsg = _my("File(s) successfully deleted.");
      }
      else
      {
        $errorFound = true;
        $lastMsg = _my("Files not deleted. Are you sure you want to delete them?");
      }
    }
    else
    {
      $errorFound = true;
      $lastMsg = _my("You should select some files first.");
    }
  }
?>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr align="LEFT" valign="TOP">
    <td><img src="img/dot.png" width="4" height="15"></td>
  </tr>
  <tr align="LEFT" valign="TOP" class="maintitle">
    <td>
      <b><font class="maintitle"><?= $TITLE ?></font></b>
    </td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr>
    <td>
      <?php
        $link = create_weps_link($config["action"]["dispatcher"], "deletefile");
      ?>
      <form name="form1" method="post" action="<?= $link ?>">
      <input type="hidden" name="catid" value="<?= $catid ?>">
      <input type="hidden" name="packid" value="<?= $packid ?>">
      <?php
        echo '<p>' . "\n";
        echo '<font class="subtitle">' . "\n";

        unset($params);
        $params["packid"] = $packid;
        $link = create_weps_link($config["action"]["dispatcher"], "package", $params);
        echo '  <b>';
        echo _my("Current file(s) in package:");
        echo '</b> <a href="' . $link . '" class="link">' . $category . $config["misc"]["CATEGORY_SEPARATOR"] . $package . '</a>' . "\n";
        echo '</font><br><br>' . "\n";
    
        $catdir = str_replace($config["misc"]["CATEGORY_SEPARATOR"], "/", $category);
    
        $query = $db->exec("select * from file where pac_id=$packid order by version desc,name");
        $n = $db->numrows($query);
        
        require("inc/filelisttable.php");
      ?>
      <table border="0" width="100%">    
        <?php
          if ($n > 0)
          {
            echo '<tr>' . "\n";
            echo '  <td align="center">' . "\n";
            echo '    <input type="submit" name="deleteButton" value="';
            echo _my("Delete");
            echo '">' . "\n";
            echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . "\n";
            echo '    <input type="checkbox" name="forcedelete" value="check">' . "\n";
            echo _my("I'm sure");
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
        <tr><td>&nbsp;</td></tr>
        <tr>
          <?php
            echo '    <td align="right">' . "\n";
            echo '      <font class="separator">' . "\n";
          
            unset($params);
            $params["catid"] = $catid;
            $params["packid"] = $packid;
          
            $link = create_weps_link($config["action"]["dispatcher"], "uploadfile", $params);
            echo '<a href="' . $link . '" class="link">';
            echo _my("Add files");
            echo '</a>&nbsp;|&nbsp;' . "\n";
          
            $link = create_weps_link($config["action"]["dispatcher"], "updatefile", $params);
            echo '<a href="' . $link . '" class="link">';
            echo _my("Update files");
            echo '</a>&nbsp;|&nbsp;' . "\n";
          
            $link = create_weps_link($config["action"]["dispatcher"], "deletefile", $params);
            echo '<a href="' . $link . '" class="link">';
            echo _my("Delete files");
            echo '</a>' . "\n";
          
            echo '      </font>' . "\n";
            echo '    </td>' . "\n";
          ?>
        </tr>
        <?php
          if (isset($lastMsg))
          {
            echo '<tr><td>&nbsp;</td></tr>' . "\n";
            echo '<tr>' . "\n";
            echo '  <td class="error">' . "\n";
            if ($errorFound) echo '   <font class="error">' . "\n";
            else echo '   <font class="message">' . "\n";
            echo '      <b>' . $lastMsg . '</b>' . "\n";
            echo '    </font>' . "\n";
            echo '  </td>' . "\n";
            echo '</tr>' . "\n";
          }
        ?>
      </table>
      </form>
    </td>
  </tr>
</table>
<?php
  require("inc/close_env.php");
?>
