#!/usr/bin/perl -w

#
# Copyright (C) 2001, 2002 Aleix Conchillo
#
# This file is part of WePS.
#
# WePS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# WePS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with WePS; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: upgrade.pl,v 1.9 2002/10/20 19:09:23 aleix Exp $
#

$VERSION = `cat ../VERSION`;
chomp($VERSION);

print "\nWePS $VERSION upgrade script\n";
print "=========================\n\n";

%config = (
           "SITE_TITLE"         => "Web Package Surfer",
           "HOME_TITLE"         => ":: Web Package Surfer ::",
           "HOME_PAGE"          => "http://localhost/weps",
           "WEPS_PATH"          => "/var/www/weps",
           "VERSION"            => $VERSION,
           "LANG"               => "en_US",
           "TYPE"               => "",
           "HOST"               => "localhost",
           "PORT"               => "",
           "NAME"               => "weps",
           "USER"               => "",
           "PASSWORD"           => "",
           "DEFAULT_THEME"      => "silvia",
           "NEWS_SCROLL"        => 5,
           "SEARCH_SCROLL"      => 10,
           "MAX_FILE_SIZE"      => 5000000,
           "CATEGORY_SEPARATOR" => "::"
           );

$config{"WEPS_PATH"} =
    read_config_param("Enter the path where you have WePS installed", "", 1);

print "\nIMPORTANT: Please, make sure that you have a copy of your WePS directory\n"
    . "(including  repository)  before upgrading.  You  may  want  to read  the\n"
    . "upgrade section in the INSTALL file first.\n\n";

$continue = "";
while (($continue ne "Yes") && ($continue ne "No")) {
    $continue =
        read_config_param("Are you sure you want to continue? (Yes/No)",
                          "Yes", 1);
}

if ($continue eq "No")
{
    print "\nBye.\n\n";
    exit;
}

$config_file = $config{"WEPS_PATH"} . "/inc/config.php";
open OLD_CFG_FILE, $config_file or die "\n$config_file: $!\n\n";

while(<OLD_CFG_FILE>)
{
    if (/^[ \t]*"(\S+)"[ \t]*=\>[ \t]*("[^"]+"|[^,]+),?/)
    {
        if (exists $config{$1})
        {
            $variable = $1;
            $_ = $2;
            s/^"([\S ]+)"$/$1/;
            $config{$variable} = $_;
        }
    }
}

close OLD_CFG_FILE;

# Sets new VERSION changing the one read from old configuration.
$config{VERSION} = $VERSION;

print "\nUpgrading WePS...";
system "cp -Rf ../weps/* $config{'WEPS_PATH'}";
print_config(%config);
print " done.\n";

print "\n*** For any problems in the upgrade process go to " .
      "Troubleshooting section\n";
print "*** in the INSTALL file.\n";

print "\n";

sub read_config_param
{
  my($cfg_str, $def, $echo) = @_;

  system "stty -echo" unless $echo;

  $answer = "";
  while ($answer eq "")
  {
      print "$cfg_str";
      if ($def ne "")
      {
          print " [$def]: ";
          chomp($answer = <STDIN>);
          $answer = $def if ($answer eq "");
      }
      else
      {
          print ": ";
          chomp($answer = <STDIN>);
      }
      print "\n" unless $echo;
  }

  system "stty echo" unless $echo;

  $answer;
}

sub print_config
{
    my(%config) = @_;

    $config_file = $config{"WEPS_PATH"} . "/inc/config.php";
    open CFG_FILE, ">$config_file" or die "\n$config_file: $!\n\n";;

print CFG_FILE <<'CONFIG_FILE';
<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
  //
  // Variables HOME_PAGE and WEPS_PATH should be the ones you should
  // change to the URL and PATH where you will have WePS installed.
  //
  $config["main"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "SITE_TITLE" => "$config{"SITE_TITLE"}",
    "HOME_TITLE" => "$config{"HOME_TITLE"}",
    "HOME_PAGE"  => "$config{"HOME_PAGE"}",
    "WEPS_PATH"  => "$config{"WEPS_PATH"}",
    "VERSION"    => "$config{"VERSION"}"
  );
CONFIG_FILE

print CFG_FILE <<'CONFIG_FILE';

  //
  // Locale configuration. Edit variable LANG to change WePS messages
  // language.
  //
  $config["locale"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "LANG" => "$config{"LANG"}"
  );
CONFIG_FILE

print CFG_FILE <<'CONFIG_FILE';

  $config["db_type"] = array(
    "PGSQL" => "pgsql",
    "MYSQL" => "mysql"
  );

  //
  // Change your database configuration. Set TYPE as one of database
  // types above (for now, just postgresql). And then set database host,
  // port and database name, user and password.
  //
  $config["database"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "TYPE"     => $config{"TYPE"},
    "HOST"     => "$config{"HOST"}",
    "PORT"     => $config{"PORT"},
    "NAME"     => "$config{"NAME"}",
    "USER"     => "$config{"USER"}",
    "PASSWORD" => "$config{"PASSWORD"}"
  );
CONFIG_FILE

print CFG_FILE <<'CONFIG_FILE';

  //
  // You may want to change values for SEARCH_SCROLL or NEWS_SCROLL,
  // this are the total number of items showed in search or news section
  // respectively. Another value you may want to change is the SITE_LOGO,
  // not much to say about this one ;).
  //
  // If you have problems uploading files, try to increment MAX_FILE_SIZE.
  // Or check section Troubleshooting in the INSTALL file.
  //
  $config["misc"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "DEFAULT_THEME"      => "$config{"DEFAULT_THEME"}",
    "NEWS_SCROLL"        => $config{"NEWS_SCROLL"},
    "SEARCH_SCROLL"      => $config{"SEARCH_SCROLL"},
    "MAX_FILE_SIZE"      => $config{"MAX_FILE_SIZE"},
    "CATEGORY_SEPARATOR" => "$config{"CATEGORY_SEPARATOR"}"
  );
CONFIG_FILE

print CFG_FILE <<'CONFIG_FILE';

  //
  // PATH variables.
  // DO NOT EDIT.
  //
  $config["path"] = array(
    "REP_HTML_PATH"   => $config["main"]["HOME_PAGE"] . "/repository",
    "REPOSITORY_PATH" => $config["main"]["WEPS_PATH"] . "/repository",
    "THEMES_PATH"     => $config["main"]["WEPS_PATH"] . "/themes",
    "LOCALE_PATH"     => $config["main"]["WEPS_PATH"] . "/locale"
  );
?>
CONFIG_FILE

  close CFG_FILE;
}
