#!/usr/bin/perl -w

#
# Copyright (C) 2001, 2002 Aleix Conchillo
#
# This file is part of WePS.
#
# WePS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# WePS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with WePS; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: install.pl,v 1.30 2002/08/24 09:57:43 aleix Exp $
#

$VERSION = `cat ../VERSION`;
chomp($VERSION);

print "\nWePS $VERSION installation script\n";
print "==============================\n\n";

$www_user = "www-data";
%config = (
           "SITE_TITLE"         => "Web Package Surfer",
           "HOME_TITLE"         => ":: Web Package Surfer ::",
           "HOME_PAGE"          => "http://localhost/weps",
           "WEPS_PATH"          => "/var/www/weps",
           "VERSION"            => $VERSION,
           "LANG"               => "en_US",
           "TYPE"               => "",
           "HOST"               => "localhost",
           "PORT"               => "",
           "NAME"               => "weps",
           "USER"               => "",
           "PASSWORD"           => "",
           "DEFAULT_THEME"      => "silvia",
           "NEWS_SCROLL"        => 5,
           "SEARCH_SCROLL"      => 10,
           "MAX_FILE_SIZE"      => 5000000,
           "CATEGORY_SEPARATOR" => "::"
           );

$config{"WEPS_PATH"} =
    read_config_param("Enter the path where you would like to install WePS",
                      $config{"WEPS_PATH"}, 1);

mkdir $config{"WEPS_PATH"}, 0755 or
    die "\nERROR: Unable to create $config{'weps_path'}: $!\n\n";

$config{"HOME_PAGE"} = read_config_param("Enter the final URL for WePS system",
                                         $config{"HOME_PAGE"}, 1);

$www_user =
    read_config_param("Enter the user that is running your web server",
                      $www_user, 1);

print "These are the database systems that WePS allows:\n\n";
print "      [1] PostgreSQL\n";
print "      [2] MySQL\n\n";
$db_type = 0;
while (($db_type <= 0) || ($db_type > 2))
{
    $db_type =
        read_config_param("Which of the above systems would you like to use?",
                          "1", 1);
}

if ($db_type == 1)
{
    $config{"TYPE"} = '$config["db_type"]["PGSQL"]';
    $config{"PORT"} = 5432;
}
if ($db_type == 2)
{
    $config{"TYPE"} = '$config["db_type"]["MYSQL"]';
    $config{"PORT"} = 3306;
}

$config{"HOST"} = read_config_param("Enter database host for WePS system",
                                    $config{"HOST"}, 1);
$config{"PORT"} = read_config_param("Enter database port for WePS system",
                                    $config{"PORT"}, 1);
$config{"NAME"} = read_config_param("Enter database name for WePS system",
                                    $config{"NAME"}, 1);
$config{"USER"} = read_config_param("Enter database user for WePS system",
                                    $config{"USER"}, 1);
$user = $config{"USER"};

$passwdok = 0;
while (!$passwdok)
{
    $config{"PASSWORD"} =
        read_config_param("Enter database password for user '$user'", "", 0);
    $config{"PASSWORD2"} =
        read_config_param("Re-type database password for user '$user'", "", 0);
    
    if ($config{"PASSWORD"} ne $config{"PASSWORD2"})
    {
        print "Passwords do not match, try again.\n\n";
    }
    else
    {
        $passwdok = 1;
    }
}

print "\nCopying WePS to $config{'WEPS_PATH'}...";
system "cp -Rf ../weps/* $config{'WEPS_PATH'}";
print " done.";
print "\nWriting WePS's configuration file...";
print_config(%config);
print " done.";
print "\nCreating repository directory...";
mkdir "$config{'WEPS_PATH'}/repository", 0755;
print " done.\n";
system "chown -R $www_user $config{'WEPS_PATH'}/repository";

print "\n";
$create_db = "";
while (($create_db ne "Yes") && ($create_db ne "No")) {
    $create_db =
        read_config_param("Do you want to create the database? (Yes/No)",
                          "Yes", 1);
}

if ($create_db eq "Yes") {
    print "\nCreating database $config{'NAME'} " .
        "for user $config{'USER'}...\n";

    if ($db_type == 1) {
        system "createdb -U $config{'USER'} $config{'NAME'}";
        system "psql -U $config{'USER'} -f weps.psql $config{'NAME'} " .
            "1> /dev/null 2> /dev/null";
    }
    if ($db_type == 2) {
        system "mysql -u $config{'USER'} -p$config{'PASSWORD'} " . 
            "-e \"create database $config{'NAME'}\"";
        system "mysql -u $config{'USER'} -p$config{'PASSWORD'} " . 
            "$config{'NAME'} < weps.mysql";
    }

    print "done.";
}

print "\n\n*** That's all! You now should be able to access WePS from " .
      "your browser at your\n";
print "*** specified URL.\n\n";
print "*** For any problems in the installation process go to " . 
      "Troubleshooting section\n";
print "*** in the INSTALL file.\n";

print "\n";

sub read_config_param
{
  my($cfg_str, $def, $echo) = @_;

  system "stty -echo" unless $echo;

  $answer = "";
  while ($answer eq "")
  {
      print "$cfg_str";
      if ($def ne "")
      {
          print " [$def]: ";
          chomp($answer = <STDIN>);
          $answer = $def if ($answer eq "");
      }
      else
      {
          print ": ";
          chomp($answer = <STDIN>);
      }
      print "\n" unless $echo;
  }

  system "stty echo" unless $echo;

  $answer;    
}

sub print_config
{
    my(%config) = @_;

    $config_file = $config{"WEPS_PATH"} . "/inc/config.php";
    open CFG_FILE, ">$config_file" or die "\n$config_file: $!\n\n";;
  
print CFG_FILE <<'CONFIG_FILE';
<?php
// Copyright (C) 2001, 2002 Aleix Conchillo
//
// This file is part of WePS.
//
// WePS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// WePS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with WePS; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
?>
<?php
  //
  // Variables HOME_PAGE and WEPS_PATH should be the ones you should
  // change to the URL and PATH where you will have WePS installed.
  //
  $config["main"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "SITE_TITLE" => "$config{"SITE_TITLE"}",
    "HOME_TITLE" => "$config{"HOME_TITLE"}",
    "HOME_PAGE"  => "$config{"HOME_PAGE"}",
    "WEPS_PATH"  => "$config{"WEPS_PATH"}",
    "VERSION"    => "$config{"VERSION"}"
  );
CONFIG_FILE
  
print CFG_FILE <<'CONFIG_FILE';

  // 
  // Locale configuration. Edit variable LANG to change WePS messages
  // language.
  //
  $config["locale"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "LANG" => "$config{"LANG"}"
  );
CONFIG_FILE

print CFG_FILE <<'CONFIG_FILE';

  $config["db_type"] = array(
    "PGSQL" => "pgsql",
    "MYSQL" => "mysql"
  );

  //
  // Change your database configuration. Set TYPE as one of database
  // types above (for now, just postgresql). And then set database host,
  // port and database name, user and password.
  //
  $config["database"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "TYPE"     => $config{"TYPE"},
    "HOST"     => "$config{"HOST"}",
    "PORT"     => $config{"PORT"},
    "NAME"     => "$config{"NAME"}",
    "USER"     => "$config{"USER"}",
    "PASSWORD" => "$config{"PASSWORD"}"
  );
CONFIG_FILE
  
print CFG_FILE <<'CONFIG_FILE';

  //
  // You may want to change values for SEARCH_SCROLL or NEWS_SCROLL,
  // this are the total number of items showed in search or news section
  // respectively. Another value you may want to change is the SITE_LOGO,
  // not much to say about this one ;).
  //
  // If you have problems uploading files, try to increment MAX_FILE_SIZE.
  // Or check section Troubleshooting in the INSTALL file.
  //
  $config["misc"] = array(
CONFIG_FILE

print CFG_FILE <<CONFIG_FILE;
    "DEFAULT_THEME"      => "$config{"DEFAULT_THEME"}",
    "NEWS_SCROLL"        => $config{"NEWS_SCROLL"},
    "SEARCH_SCROLL"      => $config{"SEARCH_SCROLL"},
    "MAX_FILE_SIZE"      => $config{"MAX_FILE_SIZE"},
    "CATEGORY_SEPARATOR" => "$config{"CATEGORY_SEPARATOR"}"
  );
CONFIG_FILE

print CFG_FILE <<'CONFIG_FILE';

  //
  // PATH variables.
  // DO NOT EDIT.
  //
  $config["path"] = array(
    "REP_HTML_PATH"   => $config["main"]["HOME_PAGE"] . "/repository",
    "REPOSITORY_PATH" => $config["main"]["WEPS_PATH"] . "/repository",
    "THEMES_PATH"     => $config["main"]["WEPS_PATH"] . "/themes",
    "LOCALE_PATH"     => $config["main"]["WEPS_PATH"] . "/locale"
  );
?>
CONFIG_FILE

  close CFG_FILE;
}
