//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <fstream>
#include <cstdlib>

#include "main.h"

#include "document.h"
#include "parser.h"
#include "generator.h"
#include "preprocessor.h"

WdtApp::WdtApp(int argc, char *argv[])
{
	parseCmdLine(argc, argv);
}

int WdtApp::run()
{
	Document   *doc	= new Document;
	Parser  *parser	= new Parser(doc);
	Generator  *gen	= new Generator;

	Preprocessor preproc(file, doc);
	parser->parseDoc();

	if (fmt == F_LATEX)
		gen->generateLaTeX(doc);
	else
		gen->generateHTML(doc);

	delete gen;
	delete parser;
	delete doc;
	
	return 0;
}

void WdtApp::parseCmdLine(int argc, char *argv[])
{
	file = "";
	for (int i = 1; i < argc; i++){
		if (argv[i][0] == '-'){
			if (argv[i][1] == 'l')
				fmt = F_LATEX;
			else {
				std::cerr << argv[0] << ": unknown argument: " << argv[i] << std::endl;
				abort();
			}
		} else if (file == "")
			file = argv[i];
		else {
			std::cerr << argv[0] <<
				" can't guess what you mean, input file name already passed: " << argv[i] << std::endl;
			abort();
		}
	}
	if (file == "") {
		std::cerr << argv[0] << " no input file specified. "; abort();
	}
}

int main(int argc, char *argv[])
{
	WdtApp app(argc, argv);

	return app.run();
}

// vim:sw=4 ts=4

