//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <string>
#include <cstdio>

#include "generator.h"
#include "units.h"

void Generator::generateHTML(Document *doc)
{
	using namespace std;
	cout	<< "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n"
			<< "  \"http://www.w3.org/TR/html4/loose.dtd\">\n"
			<< "<html>\n"
			<<	"  <head>\n"
			<< "    <title>" << doc->title << "</title>\n"
			<< "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" << doc->charset << "\">\n"
			<< "    <link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\">\n"
			<< "  </head>\n"
			<< "<body>\n"
			<< "<h1>" << doc->title << "</h1>\n";
	
	if (doc->authors.size() > 0) {
		cout << "<center><b>";
		
		if (doc->authors.size() > 1)
			cout << "Authors:<br><i>";
		else
			cout << "Author:<br><i>";
		
		for (int i = 0; i < doc->authors.size(); i++) {
			if (doc->authorsHref[i] != "#NO EMAIL#")
				cout << "<a href=\"" << doc->authorsHref[i] << "\">" << doc->authors[i] << "</a>";
			else
				cout << doc->authors[i];

			cout << "<br>\n";
		}
		
		cout << "</i></b></center>";
	}
	
	doc->makeTOC();

	cout << "<p><b>Contents:</b></p>\n";
	cout << "<ul>\n";
	for (int i = 0; i < doc->tocID.size(); i++)
	{
		cout << "  <li><b><a href=\"#id" << doc->tocID[i] << "\">" << doc->unitSect[i] << "</a></b></li>" << endl;
	}
	cout << "</ul>\n";

	int j = 1;
	for (int i = 0; i < doc->modelID.size(); i++)
	{
		switch(doc->modelT[i])
		{
			//case T_CHAP:
			//	cout << "<h1>" << "<a name=\"id" << j++ << "\"></a>" << doc->unitChap[doc->modelID[i]-1] << "</h1>\n";
			//	break;

			case T_SECT:
				cout << "<h2>" << "<a name=\"id" << j++ << "\"></a>" << doc->unitSect[doc->modelID[i]-1] << "</h2>\n";
				break;
				
			case T_P:
				{
					std::string para = reformatPara(doc->unitP[doc->modelID[i]-1]);
					cout << "<p>" << para << "</p>\n";
				}
				break;

			case T_CODE:
				{
					std::fstream f;
					f.open("wdt.in.tmp", std::ios::out);
					Code src = doc->unitCode[doc->modelID[i]-1];
					f << src.text << std::endl;
					f.close();
					std::string cmd = "highlight -Scpp -I -i wdt.in.tmp > wdt.out.tmp";
					system(cmd.c_str());
					cmd = "rm wdt.in.tmp";
					system(cmd.c_str());
					f.open("wdt.out.tmp", std::ios::in);
					std::string tmp = "";
					std::string str;
					while(f) {
						std::getline(f, str);
						tmp.append(str);
						tmp.append("\n");
					}
					f.close();
					cmd = "rm wdt.out.tmp";
					system(cmd.c_str());
					
					int pre = tmp.find("<pre>");
					tmp.erase(0, pre+5);
					pre = tmp.find("</pre>");
					tmp.erase(pre);
					cout << "<pre>" << tmp << "</pre>\n";
				}
				break;
			
			default:
				cout << "  <br>\n";
				break;
		}
	}
	
	cout << "<hr>\n";
	cout << "<center><span style=\"font-size: 90%;\">Generated by <a href=\"http://savannah.nongnu.org/projects/wdt/\">Web Documentation Typesetter</a> version 0.1 by <a href=\"mailto:stas.-AT-.plg.lrn.ru\">Stanislav Yaglo</a>.</span></center>\n";
	
	cout << "</body>\n</html>\n";
}

void Generator::generateLaTeX(Document *doc)
{
	using namespace std;
	cout	<< "\\documentclass[a4paper,11pt]{article}\n"
			<< "\\usepackage[english,russian]{babel}\n";

	if (doc->charset != "iso-8859-1")
		cout << "\\usepackage[" << doc->charset << "]{inputenc}\n";

	cout	<< "\\title{" << doc->title << "}\n"
			;
	
	if (doc->authors.size() > 0) {
		cout << "\\author{";
		for (int i = 0; i < doc->authors.size(); i++) {
			cout << doc->authors[i] << "\\\\\n";
			if (doc->authorsHref[i] != "#NO EMAIL#")
				cout << "\\texttt{" << doc->authorsHref[i] << "}\\\\\n";
		}
		cout << "}\n";
	}
	
	cout	<< "\\begin{document}\n"
			<< "\\maketitle\n"
			<< "\\pagebreak\n"
			<< "\\tableofcontents\n"
			<< "\\pagebreak\n\n"
			<< "\%\% MAIN TEXT \%\%\n"
			;
	
	int j = 1;
	for (int i = 0; i < doc->modelID.size(); i++)
	{
		switch(doc->modelT[i])
		{
			//case T_CHAP:
			//	cout << "<h1>" << "<a name=\"id" << j++ << "\"></a>" << doc->unitChap[doc->modelID[i]-1] << "</h1>\n";
			//	break;

			case T_SECT:
				cout << "\\section{" << doc->unitSect[doc->modelID[i]-1] << "}\n";
				break;
				
			case T_P:
				{
					std::string para = reformatParaLaTeX(doc->unitP[doc->modelID[i]-1]);
					cout << para << "\n";
				}
				break;

			case T_CODE:
				{
					Code src = doc->unitCode[doc->modelID[i]-1];
					cout << "\\begin{verbatim}\n" << src.text << "\\end{verbatim}\n";
				}
				break;
			
			default:
				cout << "  <br>\n";
				break;
		}
	}
	
	cout << "\\end{document}\n";
}


std::string Generator::reformatPara(std::string text)
{
	std::string newtext = "";
	bool bold = false;
	bool italic = false;
	
	for (int i = 0; i < text.size(); i++)
	{
		if (text[i] == '<') {
			newtext.append("&lt;");
			i++;
		} else if (text[i] == '>') {
			newtext.append("&gt;");
			i++;
		}
		
		if (text[i] == '*' && text[i+1] == '|') {
			newtext.append("<strong>");
			i++;
		} else if (text[i] == '|' && text[i+1] == '*') {
			newtext.append("</strong>");
			i++;
		} else if (text[i] == '/' && text[i+1] == '|') {
			newtext.append("<em>");
			i++;
		} else if (text[i] == '|' && text[i+1] == '/') {
			newtext.append("</em>");
			i++;
		} else if (text[i] == '_' && text[i+1] == '|') {
			newtext.append("<tt>");
			i++;
		} else if (text[i] == '|' && text[i+1] == '_') {
			newtext.append("</tt>");
			i++;
		} else 
			newtext.append(text,i,1);
	}

	return newtext;
}

std::string Generator::reformatParaLaTeX(std::string text)
{
	std::string newtext = "";
	bool bold = false;
	bool italic = false;
	
	for (int i = 0; i < text.size(); i++)
	{
		if (text[i] == '*' && text[i+1] == '|') {
			newtext.append("\\textbf{");
			i++;
		} else if (text[i] == '|' && text[i+1] == '*') {
			newtext.append("}");
			i++;
		} else if (text[i] == '/' && text[i+1] == '|') {
			newtext.append("\\textit{");
			i++;
		} else if (text[i] == '|' && text[i+1] == '/') {
			newtext.append("}");
			i++;
		} else if (text[i] == '_' && text[i+1] == '|') {
			newtext.append("\\texttt{");
			i++;
		} else if (text[i] == '|' && text[i+1] == '_') {
			newtext.append("}");
			i++;
		} else if (text[i] == '_') {
			newtext.append("\\_");
		} else 
			newtext.append(text,i,1);
	}

	return newtext;
}
// vim:sw=4 ts=4

