/*
    Copyright (C) 2003  John Darrington

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
const static char RCSID[]="$Id: wcal.c,v 1.1 2003/06/03 08:05:35 john Exp $";

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

static gchar *zoneName=0;
GtkWidget *calendar = 0;
GtkWidget * holiday_name = 0;

void
getDefaultZone(void)
{
  char result[100];
  FILE *pipe;
  char *s;
  char *ss;

  pipe = popen("wday -z ? -q","r");

  fgets(result, 100, pipe);

  ss = s = strtok(result," ");
  while ( s = strtok(0," ")) {
    ss = s;
  }
  s = strchr(ss,'\n');
  *s = '\0';

  zoneName = g_strdup_printf(ss);

  fclose(pipe);

}

void
populateZoneList(GtkCTree *treeWidget)
{
  GtkCTreeNode *root=0;
  GtkCTreeNode *toplevel=0;

  FILE *pipe;
  GString * command;
  char *nl=0;


  command = g_string_new("");
  g_string_sprintf(command,"wday -L");

  pipe = popen(command->str,"r");
  while(1) { 
    char result[100];
    char *nl = 0;
    static GtkCTreeNode * thisLevel = 0;

    static char *lastPref=0;

    gchar *label3;

    fgets(result,100,pipe);
    if ( feof(pipe) ) break ;
    nl = strchr(result,'\n');
    if (nl) *nl='\0';
    
    nl = strtok(result,"/");

    if ( ! lastPref ) { 
      gchar *label;
      lastPref = strdup(nl);
      label = g_strdup_printf(nl);
      thisLevel= gtk_ctree_insert_node(treeWidget,0,0,&label,1,
				       0,0,0,0, /*pixmaps*/
				       FALSE,
				       FALSE);
    }
    else {
      if ( 0 != strcmp(lastPref,nl)) {
	gchar *label2;
	label2 = g_strdup_printf(nl);
	thisLevel = gtk_ctree_insert_node(treeWidget,0,0,&label2,1,
				   0,0,0,0, /*pixmaps*/
				   FALSE,
				   FALSE);
	free(lastPref);
	lastPref = strdup(nl);
      }
    }

    nl = strtok(0,"/");

    label3 = g_strdup_printf(nl);
    gtk_ctree_insert_node(treeWidget,thisLevel,0,&label3,1,
				      0,0,0,0, /*pixmaps*/
				      TRUE,
				      FALSE);
  }
  pclose(pipe);


}


/* This function marks all the holidays in a month */
gint
calendar_mark_holidays(GtkCalendar *cal, gpointer data)
{

  gint year, month;
  gint day;

  gtk_calendar_clear_marks(cal);

  gtk_calendar_get_date (cal, &year, &month, &day);

  month++;


  gtk_calendar_freeze(cal);

  for ( day = 1 ; day <= 31 ; ++day ) { 
    FILE *pipe;
    char result[100];
    GString * command;
    char *nl=0;


    command = g_string_new("");
    g_string_sprintf(command,
		     "wday -z %s -q %04d%02d%02d 2> /dev/null ; echo $?",
		     zoneName,year, month, day); 

    pipe = popen(command->str,"r");
    fgets(result,100,pipe);
    pclose(pipe);


    nl = strchr(result,'\n');
    if ( nl ) 
      *nl='\0';

    if ( atoi(result) == 0 ) 
      gtk_calendar_mark_day(cal,day);
  }

  gtk_calendar_thaw(cal);

  return FALSE;
}

void
update_holiday(GtkCalendar *cal, GtkEntry *holiday)
{
  
  gint year, month, day;
  char *s;
  FILE *pipe;

  char result[100];

  GString * command;


  
  gtk_calendar_get_date(cal,&year,&month,&day);

  month++;

  command = g_string_new("");
  g_string_sprintf(command,"wday -z %s %04d%02d%02d",zoneName, year, month, day);
  pipe = popen(command->str,"r");
  fgets(result,100,pipe);
  pclose(pipe);

  g_string_free(command,TRUE);


  s = strchr(result,'\n');
  *s = '\0';

  gtk_entry_set_text(holiday,result);
  
}


gint
quit(GtkWidget *w, gpointer data)
{
  gtk_main_quit();
  return FALSE;
}

gboolean changeOfZone = FALSE;
GtkCTreeNode *selectedNode;

gboolean    
button_press(GtkWidget *widget,
	      GdkEventButton *event,
	      GtkCTree *ctree )
{

  if ( event->type != GDK_2BUTTON_PRESS)
    return FALSE;

  if ( changeOfZone ) {
    gtk_ctree_collapse(ctree,GTK_CTREE_ROW(selectedNode)->parent);
    gtk_ctree_select(ctree,GTK_CTREE_ROW(selectedNode)->parent);
  }

  changeOfZone = FALSE;
  
  return FALSE;
}


void        
change_zone(GtkCTree *ctree,
	      GtkCTreeNode *node,
	      gint column,
	      GtkEntry *entry)
{

  gchar *suffix;
  gchar *prefix;

  GtkCTreeRow *row = GTK_CTREE_ROW(node);

  selectedNode = node;

  changeOfZone = FALSE;
  if ( ! row->is_leaf) return ; 

  changeOfZone = TRUE;

  gtk_ctree_get_node_info(ctree,node, &suffix,0,0,0,0,0,0,0);
  gtk_ctree_get_node_info(ctree,row->parent, &prefix,0,0,0,0,0,0,0);

  g_free(zoneName);
  zoneName = g_strdup_printf ("%s/%s",prefix,suffix);
  
  gtk_entry_set_text(entry,zoneName);
  calendar_mark_holidays(GTK_CALENDAR(calendar),0);
  update_holiday(GTK_CALENDAR(calendar),GTK_ENTRY(holiday_name));
  

}

GtkWidget * 
create_zone_widget()
{
  GtkWidget * frame;
  GtkWidget * tree ;
  GtkWidget * label;
  GtkWidget * entry;
  GtkWidget * vbox;
  GtkWidget * scrolled_window;

  vbox = gtk_vbox_new(FALSE, 10 );
  
  label = gtk_label_new("Selected Zone:");
  gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);

  entry = gtk_entry_new();
  gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);

  gtk_entry_set_text(GTK_ENTRY(entry),zoneName);

  tree = gtk_ctree_new(1,0);


  gtk_signal_connect(GTK_OBJECT(tree),"tree_select_row",
		     GTK_SIGNAL_FUNC(change_zone),entry);

  gtk_signal_connect(GTK_OBJECT(tree),"button_press_event",
		     GTK_SIGNAL_FUNC(button_press),tree);



  scrolled_window = gtk_scrolled_window_new(0,0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_ALWAYS);
  
  frame = gtk_frame_new("Zone");

  populateZoneList(GTK_CTREE(tree));

  gtk_box_pack_start (GTK_BOX (vbox), label,FALSE,FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), entry,FALSE,FALSE, 0);


  gtk_container_add(GTK_CONTAINER (scrolled_window), tree );

  gtk_box_pack_start (GTK_BOX (vbox), scrolled_window ,TRUE, TRUE, 10);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  return frame;

}

int 
main(int argc, char **argv)
{

  GtkWidget * window;
  GtkWidget * vbox;
  GtkWidget * zone;
  GtkWidget * hbox;
  GtkWidget * hbox2;

  GtkWidget * frameCal ;
  GtkWidget * frameDesc ;



  gtk_init(&argc, &argv);


  getDefaultZone();

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect (GTK_OBJECT (window), "delete-event", 
                    GTK_SIGNAL_FUNC(quit),
		    0);
  

  vbox = gtk_vbox_new(FALSE, 10 );
  hbox = gtk_hbox_new(FALSE, 0 );
  hbox2 = gtk_hbox_new(FALSE, 10 );

  frameCal = gtk_frame_new("Calendar");

  calendar  = gtk_calendar_new();


  frameDesc = gtk_frame_new("Holiday");

  holiday_name = gtk_entry_new();

  gtk_entry_set_editable(GTK_ENTRY(holiday_name),FALSE);



  zone = create_zone_widget();

  gtk_signal_connect (GTK_OBJECT (calendar), "day_selected", 
                      GTK_SIGNAL_FUNC(update_holiday),
		      holiday_name);

  gtk_signal_connect (GTK_OBJECT (calendar), "month_changed", 
                      GTK_SIGNAL_FUNC(calendar_mark_holidays),
		      0);

  calendar_mark_holidays(GTK_CALENDAR(calendar),0);

  {
    time_t t;

    struct tm *tms ; 

    time(&t);

    tms = localtime(&t);

    gtk_calendar_select_day (GTK_CALENDAR(calendar),tms->tm_mday);
  }

  gtk_container_add (GTK_CONTAINER (frameCal), calendar);




  gtk_box_pack_start (GTK_BOX (hbox),frameCal, FALSE,FALSE,0);
  gtk_box_pack_start (GTK_BOX (hbox),zone, TRUE, TRUE, 0);


  gtk_container_add (GTK_CONTAINER (frameDesc), holiday_name);


  gtk_box_pack_start (GTK_BOX(vbox), hbox     , TRUE,TRUE,10  );
  gtk_box_pack_start (GTK_BOX(vbox), frameDesc , FALSE, FALSE, 10 );

  gtk_box_pack_start (GTK_BOX(hbox2), vbox , TRUE, TRUE, 10);
  gtk_container_add (GTK_CONTAINER (window), hbox2);

  
  gtk_widget_show_all(window);
    
  gtk_main ();
    
  return 0;
}





