#!/bin/sh
#
# Test that the `Nearest To' constraint works

fail ()
{
    echo $activity
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi

activity="cat 30"
cat > $TEMPDIR/foobar <<EOF
- "Thursday"  THU
- "March 15"  15 3

h "Thursday nearest March 15" ( >.< "Thursday" "March 15" )
EOF
if [ $? -ne 0 ] ; then fail ; fi

#       March 2002
#   S  M Tu  W Th  F  S
#                  1  2
#   3  4  5  6  7  8  9
#  10 11 12 13 14 15 16
#  17 18 19 20 21 22 23
#  24 25 26 27 28 29 30
#  31


# Try the closest Thursday
activity="test 40"
./build/bin/wday -d $TEMPDIR -q -z foobar 20020314
if [ $? -ne 0 ] ; then fail ; fi


# A Thursday but not the closest
activity="test 45"
./build/bin/wday -d $TEMPDIR -q -z foobar 20020321
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi

# Not  a Thursday
activity="test 62"
./build/bin/wday -d $TEMPDIR -q -z foobar 20020315
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi


# A Thursday which exactly corresponds
activity="test 69"
./build/bin/wday -d $TEMPDIR -q -z foobar 20070315
if [ $? -ne 0 ] ; then fail ; fi


pass


