#!/bin/sh
#
# Test that all the zone files parse correctly

fail ()
{
    echo $activity
    cat $TEMPDIR/out
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


activity="find zones 25"
find  build/share/wdinfo -not -type d -not -name '*,D' -not -name '*~' -not -name '*,B' | sed -e 's%build/share/wdinfo/%%' > $TEMPDIR/zones
if [ $? -ne 0 ] ; then fail ; fi


activity="test zones exist 32"
test -s  $TEMPDIR/zones
if [ $? -ne 0 ] ; then fail ; fi

activity="test zones 29"
for z in `cat $TEMPDIR/zones` ; do 
    activity="test zone $z 33"
    ./build/bin/wday -z $z > $TEMPDIR/out
    if [ $? -ne 0 ] ; then fail ; fi
done

pass
