#!/bin/sh
#
# Test that constraint of order greater than 1 work ok

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


cat > $TEMPDIR/somewhere <<EOF
- "Jan 1"   1 1
- "Monday"  MON

h "3rd Monday on or after Jan 1"   ( >3+=< "Monday" "Jan 1" )
EOF
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -q -d $TEMPDIR -z somewhere 20020121
if [ $? -ne 0 ] ; then fail ; fi 

./build/bin/wday -q -d $TEMPDIR -z somewhere 20010122
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi 

./build/bin/wday -q -d $TEMPDIR -z somewhere 20010115
if [ $? -ne 0 ] ; then fail ; fi 

cat > $TEMPDIR/somewhere <<EOF
- "Jan 1"   1 1
- "Monday"  MON

h "3rd Monday after Jan 1"   ( >3+< "Monday" "Jan 1" )
EOF
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -q  -d $TEMPDIR -z somewhere 20020121
if [ $? -ne 0 ] ; then fail ; fi 

./build/bin/wday -q  -d $TEMPDIR -z somewhere 20010115
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi 

./build/bin/wday -q  -d $TEMPDIR -z somewhere 20010122
if [ $? -ne 0 ] ; then fail ; fi 



pass
