# Test that the weekend flags work

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -l -w > $TEMPDIR/file
if [ $? -ne 0 ] ; then fail ; fi

# Check these include weekends
grep Saturday $TEMPDIR/file > /dev/null
if [ $? -ne 0 ] ; then fail ; fi

grep Sunday $TEMPDIR/file > /dev/null
if [ $? -ne 0 ] ; then fail ; fi


# try Sun March 17 2002

# with -W its not a holiday
./build/bin/wday -W -q 20020317
test $? -ne 0 
if [ $? -ne 0 ] ; then fail ; fi

# but without, it is
./build/bin/wday  -q 20020317
if [ $? -ne 0 ] ; then fail ; fi

pass
