%{ -*-c-*-
/*
    Copyright (C) 2002 John Darrington

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
const static char RCSID[]="$Id: scanner.l,v 1.10 2002/06/07 03:34:46 john Exp $";

#include "event.h"
#include "parser.h"
#include "symbol.h"
#include <assert.h>
#include <string.h>

int lineno=1;

static char *string_p = 0;
#define YY_NO_UNPUT



%}

%x COMMENT
%x IDENTIFIER

%%
^#                     { BEGIN COMMENT ;}
<COMMENT>\n            { lineno++ ; BEGIN INITIAL ; }
<COMMENT>.             ;
^"-"                   {  yylval.i = 0 ; return FLAG ;}
^"h"                   {  yylval.i = 1 ; return FLAG ;}
^"w"                   {  yylval.i = 2 ; return FLAG ;}
\"                     { 
                         free(string_p);
                         string_p = 0 ; 
                         BEGIN IDENTIFIER ;
                       };

<IDENTIFIER>\"         { 
  yylval.i = sym_insert(string_p);
  BEGIN INITIAL ; 
  return STRING ; 
};

<IDENTIFIER>[^\"]+     { 
                         
  assert ( string_p == 0 );
  string_p = (char *) calloc( strlen(yytext), sizeof(char *)); 
                         
  if ( ! string_p) { 
    perror("Cannot calloc");
    exit(1);
  }
  strcpy(string_p,yytext);
};

[0-9]+                 { yylval.i = atoi(yytext); return INTEGER ; }
moon                   { return MOON ;}

MON { yylval.i = MON ; return DOW ;}
TUE { yylval.i = TUE ; return DOW ;}
WED { yylval.i = WED ; return DOW ;}
THU { yylval.i = THU ; return DOW ;}
FRI { yylval.i = FRI ; return DOW ;}
SAT { yylval.i = SAT ; return DOW ;}
SUN { yylval.i = SUN ; return DOW ;}

\n                     {lineno++;} ;
[\t ]+                  ;
.                      { return *yytext ;};
%%

int 
yywrap()
{ 
	return 1;
}
