
%{ 
  #include "event.h"  
  #include "common.h"
  #include "event_list.h"
  #include <assert.h>
  #include <stdlib.h>
  #include <stdio.h>
  #include <string.h>

  #include "symbol.h"

  extern int lineno;
  extern char *yytext;
  extern char *zonefile;

  extern eventlist elist;

  #define ERR_NOEVENT _("The event \"%s\" has not been defined")

  int yylex();
  int yyerror();

%}

%union
{
  struct constraint* c;
  union event* e;
  struct event_header eh;
  int i;
}

%token <i>FLAG
%token <i>STRING
%token <i>INTEGER
%token <i>MOON
%token <i>DOW

%type <i>OPTINTEGER
%type <i>WILDINTEGER
%type <i>DAYLIST
%type <i>DIR
%type <c>CONSTRAINT
%type <e>EVENTSPEC
%type <e>EVENTDEF
%type <e>EVENT
%type <e>CAL
%type <e>LUNAR
%type <e>DAYOFWEEK
%type <e>CONSTRAINED
%type <e>EVENTLIST
%type <eh>EVENTLEADER

%%

EVENTLIST: /* empty */ { $$ = 0; } | EVENT | EVENTLIST EVENT 
;

EVENTLEADER: FLAG STRING
{
  struct event_header eh;
  eh.name = sym_retreive($2);
  eh.flag = $1;

  $$ = eh;
}
;

EVENTDEF:  CAL | LUNAR | DAYOFWEEK | CONSTRAINED
;

EVENT:  EVENTLEADER EVENTDEF
{
  struct event_header eh=$1; 

  union event *e  = $2 ; 

  e->eh.name=eh.name;
  e->eh.flag=eh.flag;

  /* eh.type is inhereted from $2 */

  eventl_push(&elist,e);
}
;


OPTINTEGER: 
{ $$ = 0 ; } 
| INTEGER
{ 
  if ( $1 <= 0 ) {
    yyerror(_("Year value out of range"));
  }
  $$ = $1;   
}
;

WILDINTEGER: '*'
{ $$ = -1 ; } 
| INTEGER
{
  $$ = $1; 
}
;

CAL:  WILDINTEGER WILDINTEGER OPTINTEGER
{
  struct calendarEvent *ce  = 0 ;
  ce = (struct calendarEvent *) malloc( sizeof(struct calendarEvent) );
  if  ( !ce ) { 
    perror("Cannot allocate memory");
    exit(1);
  }

  ce->eh.ty = E_CALENDAR;
  ce->dom = $1;
  ce->month = ($2 < 1 ) ? -1 :$2 - 1;
  ce->year = $3;
  

  $$ = ce;
}
;

LUNAR:  MOON INTEGER
{
  struct lunarEvent *le  = 0 ;
  le = (struct lunarEvent *) malloc( sizeof(struct lunarEvent) );
  if  ( !le ) { 
    perror("Cannot allocate memory");
    exit(1);
  }

  le->eh.ty = E_LUNAR;
  le->percent_full = $2;
  
  $$ = le;

}
;

DAYOFWEEK: DAYLIST
{
  struct dayEvent *de  = 0 ;
  de = (struct dayEvent *) malloc( sizeof(struct dayEvent) );
  if  ( !de ) { 
    perror("Cannot allocate memory");
    exit(1);
  }

  de->eh.ty = E_DOW;
  de->dow = $1;
 
  $$ = de;
}
;

DAYLIST: DOW | DAYLIST DOW
{
  $$ = $1 | $2 ;
}
;


DIR: '+'
{
  $$ = AFTER;
} 
| '-'
{
  $$ = BEFORE ;
}
| '+' '='
{
  $$ = ON_OR_AFTER ;
}
| '-' '='
{
  $$ = ON_OR_BEFORE ;
}
;

CONSTRAINT: '>' INTEGER DIR '<'
{
  struct constraint *c = 0;
  c = (struct constraint *) malloc( sizeof(struct constraint) );
  if  ( !c ) { 
    perror("Cannot allocate memory");
    exit(1);
  }


  c->ordinal = $2;
  c->dir = $3;

  $$ = c;

}
| '>' '!' '=' '<' 
{
  struct constraint *c = 0;
  c = (struct constraint *) malloc( sizeof(struct constraint) );
  if  ( !c ) { 
    perror("Cannot allocate memory");
    exit(1);
  }

  c->ordinal = 0;
  c->dir = NOT;

  $$ = c;
 
}
| '>' '.' '<'
{
  struct constraint *c = 0;
  c = (struct constraint *) malloc( sizeof(struct constraint) );
  if  ( !c ) { 
    perror("Cannot allocate memory");
    exit(1);
  }

  c->ordinal = 0;
  c->dir = NEAREST;

  $$ = c;

}
;

EVENTSPEC: '(' EVENTDEF ')'
{
  $2->eh.flag=0;
  $$ = $2;
}
| STRING 
{
  char *event_name = sym_retreive($1);

  union event *ev = eventl_get(&elist,event_name);

  if ( ! ev ) {
    char *s = 0;

    s = (char *) malloc(strlen(ERR_NOEVENT)+strlen(event_name)+1);
    if ( !s ) {
      perror("Cannot malloc");
      exit(1);
    }
    sprintf(s,ERR_NOEVENT,event_name);
    yyerror(s);
    free(s);
    s = 0;
    return 1;
  }

  $$ = ev;

}
;

CONSTRAINED: '(' CONSTRAINT EVENTSPEC EVENTSPEC ')'
{
  struct compoundEvent *ce  = 0 ;
  ce = (struct compoundEvent *) malloc( sizeof(struct compoundEvent) );
  if  ( !ce ) { 
    perror("Cannot allocate memory");
    exit(1);
  }

  ce->eh.ty = E_COMPOUND;
  ce->cstr = $2;

  ce->constrainee = $4;
  ce->constrainant = $3;

  $$ = ce;

} ;

%%

int 
yyerror(char *msg)
{
  printf(_("Error in %s line %d: %s\n"),zonefile,lineno,msg);
  printf("Last Token: \"%s\"\n",yytext);
  return 1;
}
