/*

    Copyright (C) 2002  John Darrington 

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
const static char RCSID[]="$Id: event_list.c,v 1.7 2002/04/23 06:29:00 john Exp $";

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "event_list.h"

static const size_t CHUNKSIZE=100;

void 
eventl_init(eventlist *el)
{
  el->initialised=1;
  el->next=0;
  el->table = (union event**) calloc(CHUNKSIZE,sizeof(union event *));
  if ( !el->table) {
    perror("Cannot allocate memory");
    exit(1);
  }
}

void
eventl_push(eventlist *el, union event *e)
{
  assert(el->initialised);
  assert(el->next < CHUNKSIZE);
  el->table[el->next++]=e;
  el->table[el->next]=0;
}

union event *
eventl_at(eventlist *el,int index)
{
  assert(el->initialised);
  assert(el->next < CHUNKSIZE);
  return el->table[index];
}

/* return the event in el which has the name, name, or NULL if no
   such event exists*/
union event *
eventl_get(eventlist *el, const char *name)
{
  union event **table = 0;
  assert(el->initialised);
  table = el->table;
  while (*table) { 
    if ( 0==strcmp(name,(*table)->eh.name))
      return *table;
    table++;
  }

  return 0;
}

void
eventl_print(eventlist *el)
{
  union event **table =0;
  assert(el->initialised);

  table = el->table;
  while (*table) { 
    print_event(*table);
    table++;
  }
}


/* Free free all the memory used by the list */
void 
eventl_delete(eventlist *el)
{
  union event **table = 0;
  assert(el->initialised);
  table = el->table;
  while (*table) { 
    if ( (*table)->eh.ty == E_COMPOUND ) {
      struct compoundEvent *ce = (struct compoundEvent *) (*table);
      if ( ce->cstr)
	free(ce->cstr);
      ce->cstr = 0;
    }
    free(*table);
    *table=0;
    table++;
  }
}
