#ifndef EVENT_H
#define EVENT_H
/*

    Copyright (C) 2002  John Darrington 

    $Id: event.h,v 1.9 2002/04/23 06:29:00 john Exp $

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define MON 1
#define TUE 2
#define WED 4
#define THU 8 
#define FRI 16
#define SAT 32
#define SUN 64



typedef enum { E_CALENDAR , E_DOW, E_LUNAR, E_COMPOUND } event_type;


struct event_header { 
  event_type ty;
  const char *name;
  int flag; 
};

typedef enum { BEFORE, ON_OR_BEFORE, AFTER , ON_OR_AFTER, NOT, NEAREST } direction;

struct  constraint { 
  int ordinal;
  direction dir;
} ;


struct calendarEvent { 
  struct event_header eh;
  int dom;                              /* -1 is wildcard */
  int month;   /* Jan = 0 , Dec = 11 */ /* -1 is wildcard */
  int year;                             /* 0 is  wildcard */
};

struct dayEvent {
  struct event_header eh;
  int dow;
};

struct lunarEvent {
  struct event_header eh;
  int percent_full;
};


struct compoundEvent {
  struct event_header eh;
  struct constraint *cstr;
  union event *constrainant;
  union event *constrainee;
};

union event { 
  struct event_header eh;
  struct calendarEvent;
  struct dayEvent;
  struct lunarEvent;
  struct compoundEvent;
} ;



/* These fields are analagous to those in struct tm in <time.h> */
struct dt 
{
  int     dt_mday;  /* Day of month, 1--31 */
  int     dt_mon;   /* month Jan = 0 , Dec = 11 */
  int     dt_year;  /* The canonical year*/
};


int get_day_of_week( struct dt date);


void print_event(const union event *e);

void print_constraint(struct constraint *c);



#endif /* EVENT_H */


