/*

    Copyright (C) 2002  John Darrington 

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
const static char RCSID[]="$Id: event.c,v 1.8 2002/04/23 06:29:00 john Exp $";

#include "event.h"
#include <string.h>
#include <stdio.h>
#include <assert.h>

void 
print_event(const union event *e)
{
  if ( e->eh.flag ) 
    printf("HOLIDAY ");
  else 
    printf("N ");
  printf("Event \"%s\": ",e->eh.name);
  switch (e->eh.ty) {
  case E_CALENDAR:
    {
    struct calendarEvent *ce = (struct calendarEvent *) e;
    printf("Calendar event ");
    if ( ce->dom != -1 ) 
      printf(" day of month: %d,",ce->dom);
    else
      printf(" day of month: any");

    if ( ce->month != -1 ) 
      printf(" month: %d",ce->month);
    else
      printf(" month: any");

    if ( !ce->year ) 
      printf(" year: any\n");
    else
      printf(" year: %d\n",ce->year);
    }
    break;
  case E_DOW:
    {
    struct dayEvent *de = (struct dayEvent *) e;
    printf("Day of Week event,");
    printf(" matching days %d.\n",de->dow);
    }
    break;
  case E_LUNAR:
    {
    struct lunarEvent *le = (struct lunarEvent *) e;
    printf("Lunar event: ");
    printf("percent of full, %d\n",le->percent_full);
    }
    break;
  case E_COMPOUND:
    {
    struct compoundEvent *ce = (struct compoundEvent *) e;
    printf("Compound event: ");
    if ( ce->constrainant)
    printf("Constrainant: \"%s\", ",ce->constrainant->eh.name);
    if ( ce->cstr)
    printf("Constraint: ordinal: %d, dir: %d ",ce->cstr->ordinal,ce->cstr->dir);
    if ( ce->constrainee)
    printf("Constrainee: \"%s\"",ce->constrainee->eh.name);
    printf("\n");
    }
    break;
  default:
    printf("Unknown event type\n");
     break;
  }
}

void
print_constraint(struct constraint *c)
{
  char s[3];
  printf("Constraint: ");
  
  switch (c->ordinal){
  case 1:
    strcpy(s,"st");
    break;
  case 2:
    strcpy(s,"nd");
    break;
  case 3:
    strcpy(s,"rd");
    break;
  default:
    strcpy(s,"th");
    break;
  }
  printf("%d%s ",c->ordinal,s);

  switch (c->dir) { 
  case BEFORE   :
    printf("before");
    break;
  case AFTER   : 
    printf("after");
    break;
  case ON_OR_AFTER :  
    printf("on or after");
    break;
  case ON_OR_BEFORE :
    printf("on or before");
    break;
  default:
    assert(0);
    break;
  }
  putchar('\n');
}
