LDFLAGS+=-lm
CPPFLAGS+=-I$(top_srcdir)/src -I./src -I.

all:: src/$(BINARY) 

OBJS=holiday.o zone.o pom.o vers.o scanner.o parser.o event.o symbol.o event_list.o wday.o

vpath %.c $(top_srcdir)
vpath %.h $(top_srcdir)

src/$(BINARY): $(patsubst %.o, src/%.o, $(OBJS))

src/scanner.c: $(top_srcdir)/src/scanner.l src/parser.h
	@$(RM) $@
	@$(RM) lex.yy.c
	$(LEX) $<
	mv lex.yy.c $@

src/parser.h: src/parser.c

src/parser.c: $(top_srcdir)/src/parser.y
	@$(RM) $@ src/parser.h
	$(YACC) -d $< 
	mv y.tab.c $@
	mv y.tab.h $*.h

${exec_prefix}/bin:
	mkdir -p ${exec_prefix}/bin

.PHONY: install
install:: ${exec_prefix}/bin
	$(INSTALL) src/$(BINARY) ${exec_prefix}/bin

.PHONY: uninstall
uninstall::
	$(RM) ${exec_prefix}/bin/$(BINARY)



.PHONY: clean
clean::
	$(RM) src/$(BINARY)
	$(RM) src/*.o
	$(RM) src/parser.c
	$(RM) src/scanner.c


.PHONY: maintainerclean
maintainerclean:: distclean
	$(RM) *~
