# Copyright 2003, John Darrington

MAKEINFO_FLAGS+=-I doc
TEXI2DVI_FLAGS+=-I doc

all:: doc/wday.dvi doc/wday.info

doc/wday.dvi: $(top_srcdir)/doc/wday.texinfo doc/wdversion.texi
	$(RM) $@
	$(RM) wday.toc wday.aux wday.fn wday.ky wday.tp 
	$(RM) wday.vr wday.pg wday.cps wday.cp wday.log
	$(TEXI2DVI) $(TEXI2DVI_FLAGS) $<
	mv wday.dvi doc/

doc/wday.info: $(top_srcdir)/doc/wday.texinfo doc/wdversion.texi
	$(RM) $@
	$(MAKEINFO) $(MAKEINFO_FLAGS) $< -o $@

install:: man1 man5 install-info



install-info: doc/wday.info 
	mkdir -p ${prefix}/share/info
	@$(RM) ${prefix}/share/info/wday.info
	/usr/bin/install -c $< ${prefix}/share/info
	if [ ! -e ${prefix}/share/info/dir -o -h ${prefix}/share/info/dir ] ; then rm -f ${prefix}/share/info/dir ; cp /usr/info/dir ${prefix}/share/info/dir ; fi
	install-info --infodir=${prefix}/share/info $<

man1:
	mkdir -p ${prefix}/man/man1
	@$(RM) ${prefix}/man/man1/wday.1
	/usr/bin/install -c $(top_srcdir)/doc/wday.1 ${prefix}/man/man1

man5:
	mkdir -p ${prefix}/man/man5
	@$(RM) ${prefix}/man/man5/wdinfo.5
	/usr/bin/install -c $(top_srcdir)/doc/wdinfo.5 ${prefix}/man/man5

clean::
	$(RM) *.dvi version *.log
	$(RM) *.toc *.aux *.fn *.ky *.tp *.vr *.pg *.cps *.cp 
