#!/usr/bin/env python
# -*- coding: utf-8 -*- #

import watchvideo.constants as c
import os.path
from watchvideo import main

class VideoInfo(object):
    def __init__(self, name, url, dl_url, down=True, folder=c.HOME_FOLDER, after_dl=0,
                 overwrite=False):
        self._name = name
        self.url = url
        self.dl_url = dl_url
        self.down = down
        self._folder = folder
        self.after_complete = after_dl

        if overwrite is False:
            self.filepath = main.get_new_file(self._folder, self._name)
            self._name = os.path.split(self.filepath)[1]
        else:
            self.filepath = os.path.join(self._folder, self._name)
            
        
    
    def getFolder(self):
        return self._folder
    def setFolder(self, folder):
        self._folder = folder
        self._folder = str(self._folder).decode('utf-8')
        self.filepath = main.get_new_file(self._folder, self._name)
    folder = property(getFolder, setFolder)
        
    
    def getName(self):
        return self._name
    def setName(self, name):
        self._name = name
        self._name = str(self._name).decode('utf-8')
        self.filepath = main.get_new_file(self._folder, self._name)
    name = property(getName, setName)
    
    def toPlay(self):
        self.down = False
    
    def toDownload(self):
        self.down = True

