import threading
from threading import Timer
from watchvideo.threads import Download
import datetime

class UpdateTreeItem(threading.Thread):
    def __init__(self, tree_item, dl_url, destFile):
        self.tree_item = tree_item
        self.destFile = destFile
        self.dl_url = str(dl_url)
        self.completed = False
        self.init_date = datetime.datetime.now()

        # Inicialize some variables and start downloading the video
        self.downloaded = 0
        self.size = 0
        self.local_size_ant = 0
        self.timeout = 0
        
        threading.Thread.__init__(self)
        
    def run(self):
        self.threadDl = Download(self.dl_url, self.destFile)
        self.threadDl.start()

        Timer(0.7, self.checkDownloadState).start()
        
    def checkDownloadState(self):
        self.timeout += 1
        
        self.size = self.threadDl.remote_size_kb
        
        if self.timeout == 20 and self.threadDl.local_size == 0:
            print "abort!!!"
            self.completed = True
            #self.abort(self.tr("Download aborted because server was not responding."))

        #if finished
        if self.threadDl.local_size >= self.threadDl.remote_size_kb and self.threadDl.local_size != 0 :
            self.completed = True
            self.downloaded = 100
        #else update    
        elif self.local_size_ant < self.threadDl.local_size:
            self.local_size_ant =  self.downloaded = self.threadDl.local_size
        
        if not self.completed: Timer(0.7, self.checkDownloadState).start()
        
    def getData(self):
        return [self.size, self.downloaded, self.init_date]
