# -*- coding: utf-8 -*-
# Copyright (C) 2008, 2009 Leonardo Gastón De Luca leo[at]kde.org.ar
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for CollegeHumor videos.
"""


import re

from getmediumurl.cache import cachedproperty
from getmediumurl.htmlplugin import HTMLPlugin
from getmediumurl.xmlhtml import read_xml


__all__ = ("CollegeHumor",)


class CollegeHumor(HTMLPlugin):

    """Plugin for CollegeHumor videos."""

    match_re = re.compile(r'^http://www\.collegehumor\.com/video:'
                          '(?P<mediumid>\d+)')
    url_format = u"http://www.collegehumor.com/video:%s"
    website_name = u"CollegeHumor"

    @cachedproperty
    def author_name(self):
        """Author profile name."""
        for element in self.page.getiterator("p"):
            if element.get("class") == "byLine":
                return element.findtext("a")

    @cachedproperty
    def author_url(self):
        """Author profile URL."""
        for element in self.page.getiterator("p"):
            if element.get("class") == "byLine":
                return self.make_absolute(element.find("a").get("href"))

    def get_file_url(self, high_quality=False):
        """Return file URL."""
        address = "http://www.collegehumor.com/moogaloop/video:%s" \
            % self.mediumid
        api_xml = read_xml(self.urlreader(address).content)
        return api_xml.findtext("video/file")
