/**
 * @file  imgs.c
 * @copyright Copyright (C) 2019 Michał Bąbik
 *
 * This file is part of Wall Changer.
 *
 * Wall Changer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Wall Changer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Wall Changer.  If not, see <https://www.gnu.org/licenses/>.
 *
 * @brief  Application icons
 * 
 * @author Michał Bąbik <michalb1981@o2.pl>
 */
#include "imgs.h"
/*----------------------------------------------------------------------------*/
/**
 * @brief  Icon data structure
 */
typedef struct Icon {
  guint  	 width;                        /**< Image width */
  guint  	 height;                       /**< Image height */
  guint  	 bytes_per_pixel;              /**< 2:RGB16, 3:RGB, 4:RGBA */ 
  guint8 	 pixel_data[16 * 16 * 4 + 1];  /**< Image data */
} Icon;
/*----------------------------------------------------------------------------*/
/**
 * @brief  Add icon
 */
static const Icon icon_add = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000+K'\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\061M.\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000(G%\213i\262_\377i\256`\377m\257d\377t\266k\377/I+\213"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\070b\063\200\221\367\204\377\221\361\205\377\226\363\212\377\240\374"
  "\224\377Ae<\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\070a\062\200\217\364\201\377\217\356\203\377\224\357"
  "\210\377\236\371\222\377Ac<\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000$"
  "H\040\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066^\061|\216\364\201\377\217\356\202"
  "\377\224\360\210\377\235\371\221\377?a:|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\067N\064\001\000\000\000\000\"D\036\213\061_+\200\062_-\200\064].|Bt;\277\216\364\201\377"
  "\217\355\202\377\223\360\207\377\235\371\220\377MxH\277Ab<|De@\200GgC\200"
  "\065J\061\213\000\000\000\000\000\000\000\000V\254K\377|\357m\377\200\356q\377\204\360v\377"
  "\211\362{\377\211\353|\377\216\355\201\377\223\357\206\377\226\360\213\377"
  "\241\372\225\377\246\374\232\377\253\375\237\377\262\377\247\377\203\274"
  "|\377\000\000\000\000\000\000\000\000S\246H\377x\347i\377{\347m\377\200\350r\377\204\352"
  "w\377\211\353|\377\216\356\200\377\222\357\206\377\227\361\213\377\233\363"
  "\220\377\240\364\225\377\245\366\232\377\254\373\241\377\177\266w\377\000\000"
  "\000\000\000\000\000\000S\246H\377w\347h\377{\347l\377\177\350q\377\204\352v\377\210"
  "\353|\377\215\355\200\377\222\357\206\377\226\360\212\377\233\362\217\377"
  "\240\364\224\377\244\365\232\377\253\372\240\377\177\266w\377\000\000\000\000\000\000"
  "\000\000V\253J\377{\357k\377~\356o\377\203\360t\377\207\361y\377\210\353z\377"
  "\215\355\177\377\221\356\205\377\226\360\211\377\237\372\224\377\244\374"
  "\231\377\251\375\236\377\260\377\245\377\202\273{\377\000\000\000\000\000\000\000\000\"D"
  "\035\213\061_+\200\062^,\200\063]-|Ar:\277\214\363~\377\214\355\200\377\221\356"
  "\204\377\233\370\216\377KwF\277@b;|Ce?\200GgA\200\064J\061\213\000\000\000\000$H\037"
  "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\065^/|\213\362}\377\214\354\177\377\220"
  "\357\204\377\232\370\215\377=a\071|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066N\064"
  "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066`\060\200\213\363}\377\213\354"
  "\177\377\220\357\203\377\231\367\215\377?c:\200\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\067a\061\200\214\365"
  "~\377\215\357\200\377\222\361\205\377\233\372\216\377?d:\200\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000'F#\213"
  "d\260[\377e\254[\377h\255_\377o\265f\377.H*\213\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000*J%\001\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\060L,\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Remove icon
 */
static const Icon icon_remove = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000Q\031\031\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q$$\001\000\000\000\000M\030"
  "\030\213k\"\"\200i##\200i$%\200i%%\200i''\200i((\200i**\200i++\200i,,\200"
  "i..\200i./\200k\060\060\200M\"\"\213\000\000\000\000\000\000\000\000\300;;\377\377UU\377\377"
  "WX\377\377Z[\377\377^^\377\377aa\377\377dd\377\377gh\377\377kk\377\377nn"
  "\377\377qq\377\377ut\377\377vv\377\300UU\377\000\000\000\000\000\000\000\000\272\071\070\377"
  "\377QQ\377\377ST\377\377WW\377\377ZZ\377\377]]\377\377``\377\377cc\377\377"
  "gf\377\377ji\377\377mm\377\377pp\377\377rr\377\272SS\377\000\000\000\000\000\000\000\000"
  "\272\070\067\377\377PP\377\377SR\377\377UU\377\377YX\377\377\\\\\377\377__"
  "\377\377bb\377\377ee\377\377hh\377\377lk\377\377oo\377\377ss\377\272SS\377"
  "\000\000\000\000\000\000\000\000\300\071\071\377\377RR\377\377TT\377\377WW\377\377[Z\377\377"
  "^^\377\377aa\377\377dd\377\377gg\377\377kk\377\377nn\377\377qq\377\377vv"
  "\377\300UU\377\000\000\000\000\000\000\000\000M\027\027\213k\040\040\200i!!\200i\"\"\200i$$\200"
  "i%%\200i&&\200i((\200i)(\200i**\200i++\200i--\200k//\200M\"\"\213\000\000\000\000"
  "Q\030\030\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q$$\001\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Sort icon
 */
static const Icon icon_srt = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\065\071Q\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000CGf\002\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\062"
  "\066M\213~\206\300\377|\203\274\377Y_\210\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000GLm\203"
  "\265\300\377\377\261\274\377\377\200\210\302\377\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\035\037.=HLo\177HMm|\064\067O\210\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\071\000\000\000\065\000\000\000\065\000\000\000\062\000\000\000"
  "/\000\000\000/\000\000\000\063\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000hs\277\377\226\244\377\377\232\246\377\377\236\253\377\377"
  "\245\260\377\377\254\267\377\377~\206\300\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000ep\277\377\221\240\377\377\226"
  "\243\377\377\233\250\377\377\240\254\377\377\247\263\377\377}\204\300\377"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\037@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\063\000\000\000/\000\000\000/\000\000\000/\000\000\000/\000\000\000/\000\000\000\063\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\022\025,@/\066l\203\060\067h\200\062\070h\200\065<k|\070>k|:"
  "@k|<Ak|>Cl|BFm|\061\065N\210\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000-\064m\204"
  "u\207\377\377w\210\377\377|\215\377\377\202\221\377\377\207\226\377\377\215"
  "\233\377\377\221\240\377\377\227\244\377\377\237\253\377\377v\177\302\377"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\032\037BeDP\245\320FP\240\313IS\240"
  "\313LV\240\313OY\240\313S[\240\313V_\240\313Yb\240\313^f\242\313FKu\335\000"
  "\000\000\000\026\033C\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000'*C\003\000\000\000\000&/t\335"
  "\065B\241\313\066C\237\313:F\237\313=I\237\313AL\237\313DN\240\313GQ\240\313"
  "JU\240\313NW\240\313QZ\240\313T\\\240\313Xa\242\313BHt\335\000\000\000\000\000\000\000"
  "\000?N\275\377Vk\377\377Vj\377\377\\o\377\377`s\377\377fy\377\377k}\377\377"
  "p\202\377\377u\206\377\377{\213\377\377\200\217\377\377\206\225\377\377\215"
  "\233\377\377is\276\377\000\000\000\000\000\000\000\000&/t\335\065B\241\313\065A\237\313\066"
  "B\237\313\071E\237\313<H\237\313@K\237\313CN\237\313FQ\240\313JT\240\313M"
  "V\240\313PZ\240\313T]\241\313?Et\335\000\000\000\000\026\033C\001\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000%(C\001",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Up icon
 */
static const Icon icon_up = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\000\000\000\006"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\013\022\062dh\023\062gm\000\000\000\015\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\011\027Bxl,k\304\353-i\307\356\032@~x\000\000\000\016\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\025"
  "Hwh+u\305\350\066\210\355\377\067\203\355\377.k\313\355\031@~x\000\000\000\015\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\010\024Mud)~\304"
  "\346\064\224\354\377\067\221\361\377\067\213\361\377\067\203\355\377.l\312\355"
  "\031?~w\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\023Rta'\210"
  "\302\345\063\240\354\377\065\236\361\377\066\227\361\377\066\221\361\377\067\213"
  "\361\377\067\203\355\377.l\312\355\031@~w\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\007\021Up_%\220\300\344\060\253\353\377\063\252\361\377\064\244\361\377"
  "\065\236\361\377\066\227\361\377\066\222\361\377\067\213\360\377\067\203\354\377"
  ".k\311\355\030>zv\000\000\000\015\000\000\000\000\000\000\000\002\000\007\014?\021Wp\277\"\211\264\335"
  "%\214\276\334'\215\306\356\062\246\354\377\064\244\362\377\065\236\361\377\064"
  "\224\353\377+u\305\356)j\275\334)c\266\335\032A~\311\002\011\034T\000\000\000\004\000\000"
  "\000\000\000\000\000\023\002\032$#\005/?#\002\030\"%\027`\205\221/\245\344\375\063\253\362\377"
  "\064\244\362\377\061\225\343\375\030S\204\221\002\013\"%\007\034<#\004\022-$\000\000\000\027"
  "\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\027f\207\177.\253\343\376"
  "\062\261\362\377\063\253\362\377\060\233\343\376\030Y\207\177\000\000\000\001\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\026i\207"
  "\200-\261\343\376\061\267\362\377\062\261\362\377/\241\343\376\030\\\207\200"
  "\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\001\026m\207\200,\267\344\376\060\276\363\377\061\270\362\377.\247\343"
  "\376\027`\207\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\001\025q\207\200+\275\344\376/\304\363\377\060\276\363"
  "\377-\255\343\376\027d\207\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\025u\210\200*\302\343\376.\312\362\377"
  "/\304\362\377,\262\343\376\026h\210\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\015\\in\037\233\263\332\"\241"
  "\276\334\"\234\276\334\040\216\262\332\017Rin\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021\004\064;#\004-\066"
  "#\004+\066#\005.;#\000\000\000\021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Down icon
 */
static const Icon icon_down = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021\007\032:#\006\025\065#\006\024\065"
  "#\007\024:#\000\000\000\021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\002\023\065hn']\260\332+_\274\334,Z\274\334)P\260\332"
  "\024+gn\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\001\033I\206\200\064|\341\376\071\177\360\377:y\357\377\066l\340\376"
  "\035<\206\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\001\032M\206\200\063\203\342\376\070\207\361\377\071\200\360"
  "\377\066r\341\376\034@\206\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\032Q\206\200\063\211\342\376\067\215\361"
  "\377\070\207\361\377\065y\342\376\033D\206\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\031U\206\200\062\220\342"
  "\376\066\224\361\377\067\215\361\377\064\177\342\376\033G\206\200\000\000\000\001\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\030Y"
  "\207\177\061\226\343\376\065\232\361\377\066\224\361\377\063\205\342\376\032K"
  "\206\177\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023\002\033$#"
  "\005\060?#\002\032\"%\027\\\205\221\060\235\343\375\064\241\362\377\065\233\361\377"
  "\062\214\343\375\031N\204\221\002\015\"%\007\035<#\004\023-$\000\000\000\027\000\000\000\001\000\000\000"
  "\002\000\010\014?\020Zq\277!\220\264\335$\223\276\334'\223\306\356\061\252\354\377"
  "\063\247\362\377\064\241\361\377\064\227\354\377*z\305\356)p\275\334(h\267\335"
  "\031C\177\311\002\011\034T\000\000\000\004\000\000\000\000\000\000\000\007\020Zp_#\233\301\344.\274\354"
  "\377\061\273\362\377\062\265\362\377\063\256\362\377\063\250\361\377\064\241\361"
  "\377\065\233\361\377\065\222\355\377,v\311\355\027Bzv\000\000\000\015\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\007\021^ta$\236\303\345/\275\355\377\061\273\362\377\062\265"
  "\362\377\063\256\362\377\063\250\362\377\063\237\356\377+\202\313\355\027L~w"
  "\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\010\021_vd$\237\305"
  "\346/\275\356\377\061\274\362\377\062\265\362\377\062\254\356\377*\215\314\355"
  "\026S\177w\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\011\022awh%\241\307\350/\276\356\377\060\271\357\377(\230\314\355\026"
  "Z\177x\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\011\022cyl$\240\305\353&\240\311\356\025b\200x\000\000\000\016"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\013\015Reh\016Shm\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\005\000\000\000\006\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Floppy icon
 */
static const Icon icon_floppy = {
  16, 16, 4,
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\232\005\005\005\001\007\007"
  "\007\001\000\000\000-\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\006\006\006\001\006\006\006"
  "\001\007\007\007\001\010\010\010\001\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\001\000\000\000\001\377\377\377\000\377\377\377\000\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\272\000\000\000\001\377\377\377\000\000\000\000E\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\014rrr\000\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\001"
  "\377\377\377\000\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\001\377\377\377\000\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\001\377\377\377\000\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Screen icon
 */
static const Icon icon_screen = {
  16, 16, 4,
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\001\000\002\307\000\000\000\302\000\000\000\310\000\000\000\317\000\000\000\324\000\000\000\330\000\000\000\334"
  "\000\000\000\337\000\000\000\340\000\000\000\337\000\000\000\340\000\000\000\340\000\000\000\340\000\000\000\334\000"
  "\001\001\330\000\001\003\335\000\000\001\230\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\000\000\000\227\000\000\001\234\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\001\000\000\241\000\000\001\242\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000"
  "\000\000\252\000\000\001\247\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000"
  "\000\000\263\000\000\002\253\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000"
  "\000\000\275\000\000\002\257\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\001"
  "\000\000\307\000\000\002\265\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\001"
  "\000\000\320\000\000\000\271\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000"
  "\000\000\330\001\000\000\273\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000"
  "\000\000\342\034\022\014V\024\026\015V\023\015\004W\031\017\001X\027\016\001W\024\012\001Y\026\014\001"
  "Z\004\004\003\245\010\005\003\234\022\014\000[\024\011\001]\024\010\000]\024\012\000^\025\011\001\\\023\012"
  "\001]\023\007\001`\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\000\003\002[\000\001\001e\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\000\035$\022\000\035\026\033XXX\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\034,\"\002\001\025,\032\004\021*\060\001\012\030o\023\022\021\204\031\032\032n"
  "\027\027\027w\023\027\030n\026\031\032s\023\030\030~\014\017\015d\034\025\004O\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Quit icon
 */
static const struct {
  guint  	 width;
  guint  	 height;
  guint  	 bytes_per_pixel; /* 2:RGB16, 3:RGB, 4:RGBA */ 
  guint8 	 pixel_data[20 * 20 * 4 + 1];
} icon_exit = {
  20, 20, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\035\225\000\000\033\224\000\000\033\224\000\000\033\224"
  "\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033"
  "\224\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033\224\000\000\033\224\000"
  "\000\033\224\000\000\033\224\000\000\034\224\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\210\037J\000\205!i\000\204"
  "!g\000\204!g\000\204!f\000\207\040`\001\210\040_\001\207\040_\001\207\040_\001\207\040_\001\207"
  "\040_\001\207\040_\001\207\040_\000\207\040`\001\207\040_\001\207\040_\001\207\040_\001\207\040"
  "_\001\207\040d\001\210\040H\002\210\040\303\026\222\035\326\036\225\034\303\036\225\034"
  "\303\031\223\034\312\002\210!\371\000\207!\377\000\207!\376\000\207!\376\000\207!\376"
  "\000\207!\376\000\207!\375\000\206!\377\000\207!\377\000\206!\377\000\207!\376\000\207"
  "!\376\000\207!\376\000\207!\377\000\207!\301\005\211\037\256\203\307\011g\364\376\000"
  "C\360\374\000D\250\330\002W\006\212\040\333\000\206!\355\000\207!\351\000\207!\351\000\207"
  "!\351\000\207!\351\000\207!\353\010\213\040\327\210\311\007b!\230\033\256\000\204\""
  "\372\000\206\"\361\000\207!\351\000\207!\365\000\207!\261\005\211\037\256q\276\014q\304"
  "\346\000N\301\345\000O\215\313\007a\006\212\040\334\000\206!\354\000\207!\353\000\207!\351"
  "\000\207!\351\000\207!\351\000\207!\353\012\214\037\324\270\340\000Re\270\015s*\233"
  "\031\242.\235\031\237\000\206\"\360\000\207!\364\000\207!\261\005\211\037\256t\277\014"
  "o\313\352\000M\310\350\000M\221\315\006_\006\212\040\333\000\205\"\363\000\207!\353\000"
  "\205\"\361\000\205\"\361\000\206!\355\000\207!\352\000\203\"\374-\235\030\240\377"
  "\377\000A\067\242\026\225\070\242\027\224\071\242\026\224\000\206!\373\000\207!\262\005"
  "\211\037\256t\277\014o\313\352\000M\310\350\000M\221\315\006_\003\210\040\343\036\226"
  "\033\262y\302\013i\061\237\030\235:\243\026\224\030\223\035\275\017\216\036\313\066"
  "\241\027\230c\267\016u\271\340\000R\223\316\007^\006\212\040\333\040\226\033\257\000\207"
  "!\364\000\207!\263\005\211\037\256t\277\014o\313\352\000M\310\350\000M\221\315\006_\004"
  "\211\040\337\016\216\036\314\063\237\027\231\026\222\035\277\031\224\034\271\014\215"
  "\037\320\010\213\040\330\032\224\034\270\017\217\036\312\012\214\037\323\377\377\000"
  "?N\255\022\202\000\204\"\370\000\207!\364\000\207!\261\005\211\037\256t\277\014o\313"
  "\352\000M\310\350\000M\221\315\006_\006\212\040\333\000\205\"\363\000\205\"\362\000\205"
  "\"\362\000\205\"\362\000\206!\356\000\206!\354\000\205\"\365\001\210!\346X\262\020{"
  ":\243\026\223A\247\024\215\000\204\"\367\000\205\"\377\001\207!\261\005\211\037\256"
  "t\277\014o\314\352\000L\311\351\000M\221\316\006_\006\212\040\334\000\206!\354\000\207"
  "!\351\000\207!\351\000\207!\351\000\207!\351\000\207!\351\000\206!\357\025\221\035\300"
  "=\244\025\220\000\206!\354{\303\012hV\261\021}E\250\024\220\000\206!\265\005\212\037"
  "\254\217\315\007a\377\377\000=\377\377\000=\271\341\000Q\007\212\040\330\000\206!\352"
  "\000\207!\346\000\207!\346\000\207!\346\000\207!\346\000\207!\346\000\206!\354\024\220"
  "\035\300\067\242\026\223\000\205\"\360\004\211\040\335\011\213\037\322\010\213\040\337"
  "\000\207!\260\002\210\040\274\027\222\035\315\037\226\033\273\037\226\033\273\033\224"
  "\034\302\002\210!\361\000\207!\367\000\207!\366\000\207!\366\000\207!\366\000\207!\366"
  "\000\207!\366\000\207!\367\003\211\040\356\006\212\040\347\000\207!\370\000\207!\366\000"
  "\207!\367\000\207!\377\000\207!\273\002\210\040=\000\202\"Z\000\201#Z\000\201#Z\000\202"
  "\"Y\001\207\040O\002\210\040M\002\210\040N\002\210\040N\002\210\040N\002\210\040N\002\210\040"
  "N\002\210\040M\000\207!O\000\206!Q\003\210\040M\002\210\040N\002\210\040N\002\210\040Q\002\210"
  "\040;\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Make icon from Icon struct.
 *
 * @param[in]  ic_name  Name of Icon struct
 * @return     Pixbuf with icon
 */
GdkPixbuf *
make_icon (const Icon *ic_name)
{
    return gdk_pixbuf_new_from_data (
            ic_name->pixel_data,
            GDK_COLORSPACE_RGB,
            TRUE,
            8,
            ic_name->width,
            ic_name->height,
            ic_name->width * ic_name->bytes_per_pixel,
            NULL,
            NULL
            );
}
/*----------------------------------------------------------------------------*/
/**
 * @brief  Get image from stored data.
 *
 * @param[in]  i_img  Image number
 * @return     Pixbuf with image
 */
GdkPixbuf *
get_image (const uint8_t i_img)
{
    GdkPixbuf *gp_pbuf = NULL;

    if (i_img == 2 || i_img == 3)
        gp_pbuf = make_icon (&icon_add);
    else if (i_img == 4)
        gp_pbuf = make_icon (&icon_remove);
    else if (i_img == 7)
        gp_pbuf = make_icon (&icon_srt);
    else if (i_img == 5)
        gp_pbuf = make_icon (&icon_up);
    else if (i_img == 6)
        gp_pbuf = make_icon (&icon_down);
    else if (i_img == 9)
        gp_pbuf = make_icon (&icon_floppy);
    else if (i_img == 8)
        gp_pbuf = make_icon (&icon_screen);
    else if (i_img == 1) {
        gp_pbuf = gdk_pixbuf_new_from_data (
                icon_exit.pixel_data,
                GDK_COLORSPACE_RGB,
                TRUE,
                8,
                icon_exit.width,
                icon_exit.height,
                icon_exit.width * icon_exit.bytes_per_pixel,
                NULL,
                NULL
                );
    }
    return gp_pbuf;
}
/*----------------------------------------------------------------------------*/


