/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "user.h"
#include "icons.h"
#include "vcprotocol.h"
#include "global.h"
#include <qtooltip.h>
#include <qpainter.h>

User::User(QListBox *list, const QString &nick, const QHostAddress &addr): QListBoxItem(list), dcnt(1), ip(addr) /*{{{*/
{
	setNick(nick);
	setStatus(STATUS_NORMAL);
}/*}}}*/

User::~User()/*{{{*/
{
}/*}}}*/

void User::paint(QPainter *p)/*{{{*/
{
	switch (status)
	{
		case STATUS_NORMAL : p->drawPixmap(0, 0, Icons::icon_user.pixmap(QIconSet::Small, true)); break;
		case STATUS_DND    : p->drawPixmap(0, 0, Icons::icon_user_dnd.pixmap(QIconSet::Small, true)); break;
		case STATUS_AWAY   : p->drawPixmap(0, 0, Icons::icon_user_away.pixmap(QIconSet::Small, true)); break;
		case STATUS_OFFLINE: p->drawPixmap(0, 0, Icons::icon_user_offline.pixmap(QIconSet::Small, true)); break;
		default: break;
	}
	p->drawText(Icons::icon_user.pixmap().width() + 2, p->fontMetrics().ascent(), text());
}/*}}}*/

int User::height(const QListBox *lb) const/*{{{*/
{
	return QMAX(lb->fontMetrics().height(), Icons::icon_user.pixmap(QIconSet::Small, true).height());
}/*}}}*/

int User::width(const QListBox *lb) const/*{{{*/
{
	return Icons::icon_user.pixmap(QIconSet::Small, true).width() + lb->fontMetrics().width(text()) + 2;
}
	
const QPixmap* User::pixmap() const
{
	return NULL;
}/*}}}*/

void User::setToolTipInfo(const QString &info)/*{{{*/
{
	//QToolTip::add(static_cast<QListBoxItem*>(this), info);
}/*}}}*/

