/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __TOPICWIN_H
#define __TOPICWIN_H

#include <qdialog.h>

class QPushButton;
class QLineEdit;

class TopicWin: public QDialog
{
	Q_OBJECT
	private:
		QLineEdit *le_topic;
		QPushButton *b_ok;
		QPushButton *b_cancel;
		QString channel;
		
	signals:
		void newTopic(const QString &channel, const QString &txt);
		
	protected slots:
		virtual void accept();

	public:
		TopicWin(QWidget *parent, const QString &channel, const QString &topic);
		~TopicWin();
};


#endif

