/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SETTINGSDLG_H
#define __SETTINGSDLG_H

#include <qtabdialog.h>
#include "sound.h"
#include "icons.h"

class QListBox;
class QLineEdit;
class QCheckBox;
class QComboBox;
class QSpinBox;
class QLabel;
class QButtonGroup;
class QVButtonGroup;
	
class SettingsDialog: public QTabDialog
{
	Q_OBJECT

	private slots:
		void slotApply();
		void slotDefaults();
		void slotPopupCheckBoxChanged(bool state);
		void slotThemeSelected(int index);
		void slotSoundSystemClicked(int index);
		void slotUseBroadcastToggled(bool state);
		void slotBrowseSample(int id);
		void slotSampleEnable(int id);
		void slotBrowseScript(int id);
		void slotScriptEnable(int id);
		
	private:
		//test
		QCheckBox *cb_scr[7], *cb_wav[7];
		QLineEdit *le_scr[7], *le_wav[7];
		QPushButton *b_browsescr[7], *b_browsewav[7];
		//--test

		QButtonGroup *b_scrbrgroup,
			     *b_screngroup,
			     *b_wavbrgroup,
			     *b_wavengroup;
		QLineEdit *le_nick,
			  *le_hostname,
			  *le_ip,
			  *le_broadcast,
			  *le_multicast,
			  *le_sndname,
			  *le_playcmd; //play command name
 		QSpinBox *sp_refresh, *sp_port;
		QVButtonGroup *opt_snddev;
		QCheckBox *b_hide,
			  *b_popup,
			  *b_popupdnd,
			  *b_systray,
			  *b_play, // play selected sound
			  *b_confirmexit,
			  *b_useutf,
			  *b_exec; // execute script
		QListBox *snd_list;
		QComboBox *l_enc;
		QLabel *theme_info;
		Settings *settings;
		QComboBox *themes_list;
		ThemesList themes;
	
		struct EvtString {
			QString name;
			VyEvent evt;
		};

		static EvtString btns[];
		
		void setupNetworkTab(QWidget *p);
		void setupSoundDeviceTab(QWidget *p);
		void setupSoundsTab(QWidget *p);
		void setupScriptsTab(QWidget *p);
		void setupLookTab(QWidget *p);
		void setupMiscTab(QWidget *p);

	signals:
		void networkSettingsChanged();
		void themeChanged();
		void soundSettinsChanged();
		void systraySettingsChanged();

	public:
		SettingsDialog(QWidget *parent, Settings *s);
		~SettingsDialog();
};

#endif

