#include "scripting.h"
#include <qdatetime.h>
#include <qstring.h>
//#include <unistd.h>
#include <stdlib.h>
#include <qprocess.h>
#include <iostream>

bool Scripting::run(const QString &fname, const QStringList &env)/*{{{*/
{
	QProcess proc(fname, NULL);
	return proc.start(&const_cast<QStringList &>(env));
}/*}}}*/

void Scripting::executeChatline(const QString &fname, const QDateTime &date, const QString &channel, const QString &from, const QString &text)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=C");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	env.push_back("TEXT=" + text);
	run(fname, env);
}/*}}}*/

void Scripting::executeMessage(const QString &fname, const QDateTime &date, const QString &from, const QString &text)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=M");
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	env.push_back("TEXT=" + text);
	run(fname, env);
}/*}}}*/

void Scripting::executeJoin(const QString &fname, const QDateTime &date, const QString &channel, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=J");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeLeave(const QString &fname, const QDateTime &date, const QString &channel, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=L");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeBeep(const QString &fname, const QDateTime &date, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=B");
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeInfoRequest(const QString &fname, const QDateTime &date, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=I");
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeRegexpMatch(const QString &fname, const QDateTime &date, const QString &channel, const QString &from, const QString &text)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=R");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	env.push_back("TEXT=" + text);
	run(fname, env);
}/*}}}*/

