/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __ICONS_H
#define __ICONS_H

#include <qiconset.h>
#include <qvaluelist.h>

class QStringList;

class ThemeInfo
{
	private:
		QString name;
		QString fullpath;
		QString info;
	public:
		ThemeInfo() {}
		ThemeInfo(const QString &n, const QString &p, const QString &i): name(n), fullpath(p), info(i) {}
		~ThemeInfo() {};
		const QString& getName() const { return name; }
		const QString& getPath() const { return fullpath; }
		const QString& getInfo() const { return info; }
};

typedef QValueList<ThemeInfo> ThemesList;

class Icons
{
	public:
		enum { Command, User, UserDND, UserAway, UserOffline,
		       Channel, ChannelNormal, ChannelAlert, Private,
		       PrivateAlert, Info, Message, MassMessage, Enter,
		       Settings};

		static QIconSet icon_comm;
		static QIconSet icon_user;
		static QIconSet icon_user_dnd;
		static QIconSet icon_user_away;
		static QIconSet icon_user_offline;
		static QIconSet icon_channel;
		static QIconSet icon_channel_normal;
		static QIconSet icon_channel_alert;
		static QIconSet icon_private;
		static QIconSet icon_private_alert;
		static QIconSet icon_info;
		static QIconSet icon_message;
		static QIconSet icon_massmessage;
		static QIconSet icon_enter;
		static QIconSet icon_settings;
		static QIconSet icon_beep;

		static void init();
		static ThemesList getThemes();
		static bool setTheme(const QString &name);
		static bool setTheme(const ThemeInfo &theme);
		static QIconSet& getIcon(int i);
};

#endif

