/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CHLIST_H
#define __CHLIST_H

#include <qstringlist.h>
#include <qdialog.h>

class QLineEdit;

class ChannelList: private QStringList
{
	public:
		ChannelList();
		~ChannelList();
		void add(const QString &name);
		void add(const QStringList &list);
		bool del(const QString &name);
		QStringList list();
};

class ChannelsDialog: public QDialog
{
	Q_OBJECT
	private:
		QLineEdit *le_channel;

	signals:
		void joinChannel(const QString &);
		
	private slots:
		void slotJoinClicked();
	
	public:
		ChannelsDialog(QWidget *parent, ChannelList *chlist);
		~ChannelsDialog();

};

#endif

