/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CHATLINE_H
#define __CHATLINE_H

#include <qlineedit.h>
#include <qstringlist.h>

class ChatLine: public QLineEdit 
{
	Q_OBJECT
		
	private:	
		int histmax;
		int histpos;
		QStringList hist;
		
	protected:
		void keyPressEvent(QKeyEvent *e);
			
	public slots:
		void sayNick(const QString &nick);
		
	public:
		ChatLine(QWidget *parent, int max = 50);
		~ChatLine();
		QStringList getHistory() const;
		virtual void paste();
};

#endif

