/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CHANNEL_H
#define __CHANNEL_H

#include <qtextedit.h>

class QPopupMenu;
class ChatTab;

class Channel: public QTextEdit
{
	Q_OBJECT
	private:
		QString chname;
		QString topic;
		bool prv;
		bool activity;
		QString filename;

	protected:
		QPopupMenu *createPopupMenu(const QPoint &pos);
		bool doSave();

	signals:
		void leave(const QString &name);

	private slots:
		void leave();

	public slots:
		void save();
		void saveAs();		
	public:
		Channel(QWidget *parent, const QString &name, const QString &topic, bool prv=false);
		Channel(QWidget *parent, const QString &name, bool prv=false);
		~Channel();
		QString name() { return chname;	}
		bool isPrivate() { return prv; }
		QString setTopic(const QString &t) { return topic = t; }
		QString getTopic() { return topic; }
		bool getActivity() { return activity; }
		bool setActivity(bool a) { return activity = a; }

		friend class ChatTab;
};

#endif

