/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __APPWIN_H
#define __APPWIN_H

#include <qmainwindow.h>
#include <qregexp.h>
#include <qmemarray.h>
#include "history.h"
#include "global.h"

class ChannelList;
class Settings;
class User;
class UsersList;
class ChatTab;
class ChatLine;
class VyPacket;
class NickCombo;
class VCProtocol;
class QHostAddress;
class TrayIcon;
class QStringList;
class QMenuBar;
class QToolBar;
class QPopupMenu;
class QSocketNotifier;
class QComboBox;

class MainWindow: public QMainWindow
{
	Q_OBJECT
	private:
		QMenuBar *main_menu;
		QPopupMenu *view_menu;
		QPopupMenu *systraymenu;
		QToolBar *main_toolbar;
		QComboBox *status_combo;
		TrayIcon *tray;
		NickCombo *nickcmb;
		ChatLine *chatline;
		ChatTab *chattab;
		UsersList *userslist;
		VCProtocol *vc;
		QSocketNotifier *socknotify;
		static const char * status_lut[];

		//
		// current options and status
		ChannelList *availchannels;
		History dnd_list;
		History away_list;
		History offline_list;
		History regexp_list;
		History nick_list;
		Settings *settings;
		QString nick;
		QString autoanswer;
		QColor special_color;
		QColor normal_color;
		QColor own_color;
		QRegExp regexp;
		bool regexp_on;
		char status;
		char winstate;
		char gender;
		char remoteactive;
		QString tmp;

		//
		// ids for menu items assigned by Qt
		int tbar_id;
		int ulist_id;
		int nickcmb_id;

		bool parse(QString &str);
		void startChat();
		bool confirmExit();

	protected slots:
		void closeEvent(QCloseEvent *e);
		void setupSystray();
		void reconfigureSystray();
		void reconfigureNetwork();
		void sendLine();
		void simulateEnter();
		void systrayClicked();
		
		void on_vc_say(const QString &channel, const QString &from, const QString &text);
		void on_vc_me(const QString &channel, const QString &from, const QString &text);
		void on_vc_whohere(const QString &updater);
		void on_vc_imhere(const QHostAddress &source, const QString &updater, const QString &responder, char status, char winstate);
		void on_vc_imhere(const QHostAddress &source, const QString &updater, const QString &responder, char status, char winstate, char gender, Q_INT16 color);
		void on_vc_beep(const QHostAddress &source, const QString &to, const QString &from);
		void on_vc_beepack(const QString& to, const QString& from, char gender);
		void on_vc_join(const QHostAddress &source, const QString &who, const QString &channel, char status, char gender);
		void on_vc_leave(const QString &who, const QString &channel, char gender);
		void on_vc_private_join(const QString &from, const QString &to, char gender);
		void on_vc_private_leave(const QString &from, const QString &to, char gender);
		void on_vc_private_say(const QString &from, const QString &to, const QString &text);
		void on_vc_private_me(const QString &from, const QString &to, const QString &text);
		void on_vc_message(const QHostAddress &source, const QCString &sig, const QString &from, const QString &to, const QString &text);
		void on_vc_massmessage(const QHostAddress &source, const QCString &sig, const QString &from, const QString &to, const QString &text);
		void on_vc_messageack(char status, const QString &from, const QString &to, char gender, const QString &answer);
		void on_vc_herereq(const QHostAddress &source, const QString &from, const QString &channel);
		void on_vc_hereack(const QString &to, const QString &channel, const QString &from, char ra);
		void on_vc_inforeq(const QString &to, const QString &from);
		void on_vc_inforeqack(const QHostAddress &source, const QString &to, const QString &from, const QString &comp, const QString &name, const QString &ip, const QString &channels, const QString &answer, const QString &computer, const QString &software, bool utf);
		void on_vc_nickchange(const QString &from, const QString &to, char gender);
		void on_vc_changestatus(const QString &who, char status, char gender, const QString &answer);
		void on_vc_currenttopic(const QString &to, const QString &channel, const QString &topic);
		void on_vc_newtopic(const QString &channel, const QString &topic);
		void on_vc_ping(const QHostAddress &source, const QString &to, const QString &from, const QString &time);
		void on_vc_pong(const QString &to, const QString &from, const QString &time);
		void on_vc_floodnotify(const QString &to, const QString &from, const QString &seconds);
			
	public slots:
		void openSendMessage(const QString &to);
		void openSendMassMessage(const QStringList &nicks);
		void sendMessage(const QString &to, const QString &msg);
		void sendMassMessage(const QStringList &nicks, const QString &msg);
		void requestInfo(const QString &who);
		void changeNick(const QString &newnick);
		void joinChannel(const QString &channel);
		void leaveChannel(const QString &channel);
		void beep(const QString &who);
		void openPrivate(const QString &who);
		void goNORMAL();
		void goDND(const QString &txt);
		void goAWAY(const QString &txt);
		void goOFFLINE(const QString &txt);
		void forceRefresh();
		void slotMenuDummy();
		void openTopicDialog();
		void openSettingsDialog();
		void openRegexpDialog();
		void openDNDdialog();
		void openAWAYdialog();
		void openOFFLINEdialog();
		void newTopic(const QString &channel, const QString &txt);
		void slotChangeRegexp(const QString &txt, bool on);
		void slotStatusComboActivated(int item);
		void usersListUpdate();
		void popupAbout();
		void openChannelsDialog();
		void commandMenuAction(int option);
		void openChatLineHistory();
		void cancelStatusChange();

		void toggleToolbar();
		void toggleUsersList();
		void toggleNickCombo();

	public:
		//
		// IDs for command menu items
		enum {
			ID_ENTER_ME = ID_COMMAND_MENU,
			ID_ENTER_NICK,
			ID_ENTER_JOIN,
			ID_ENTER_LEAVE,
			ID_ENTER_CHAT,
			ID_ENTER_TOPIC,
			ID_ENTER_INFO,
			ID_ENTER_BEEP,
			ID_ENTER_MASS,
			ID_ENTER_HERE,
			ID_ENTER_NORMAL,
			ID_ENTER_DND,
			ID_ENTER_AWAY,
			ID_ENTER_OFFLINE,
			ID_ENTER_HELP
		};

		MainWindow(QWidget *parent, Settings *s);
		~MainWindow();
};

#endif

