/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "uuid.h"
#include <qstring.h>
#include <openssl/rand.h>

UUID::UUID(): QByteArray(UUID_LEN)/*{{{*/
{
}/*}}}*/

UUID::UUID(const QString &str): QByteArray(UUID_LEN)/*{{{*/
{	
	if (str == QString::null)
		generate();
	else
	{
		if (!set(str))
			generate();
	}
}/*}}}*/

UUID::~UUID()/*{{{*/
{
}/*}}}*/

void UUID::generate()/*{{{*/
{
	RAND_bytes((unsigned char *)data(), UUID_LEN);
}/*}}}*/

void UUID::set(const unsigned char *data)/*{{{*/
{
	duplicate(reinterpret_cast<const char *>(data), UUID_LEN);
}/*}}}*/

bool UUID::set(const QString &str)/*{{{*/
{
	if (str.length() != 2*UUID_LEN)
		return false;

	int k = 0;

	for (int i=0; i<UUID_LEN; i++)
	{
		unsigned char val = 0;
		
		for (int j=0; j<2; j++)
		{
			const char c = str[k++];
			
			if (c >= '0' && c <= '9')
				val |= c - '0';
			else if (c >= 'a' && c <= 'f')
				val |= c - 'a' + 10;
			else if (c >= 'A' && c <= 'F')
				val |= c - 'A' + 10;
			else
				return false;
			val <<= 4;
		}
		at(i) = val;
	}
	return true;	
}/*}}}*/

QString UUID::asString() const/*{{{*/
{
	QString r;
	for (int i=0; i<UUID_LEN; i++)
	{
		const unsigned char c = at(i);
		if (c < 16)
			r += '0';
		r += QString::number(c, 16);
	}
	return r;
}/*}}}*/

