/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __USER_H
#define __USER_H

#include <qhostaddress.h>
#include <qlistbox.h>
#include "global.h"

class QPainter;

class User: public QListBoxItem
{
	private:
		char gender;
		char status;
		QHostAddress ip;
		int dcnt;
		QString nick;
		
		bool setGender(char g) { gender=g; return true; }
		bool User::setStatus(char s) { status=s; return true; }
		void setNick(const QString &nick) { setText(nick); }
		int incDeadCounter() { if (dcnt<1) dcnt++; return dcnt; }
		int decDeadCounter() { return --dcnt; }
		
	public:
		User(QListBox *list, const QString &nick, const QHostAddress &addr);
		~User();
		char getGender() const { return gender; }
		char getStatus() const { return status; }
		QString getNick() const { return text(); }
		const QHostAddress& getIP() const { return ip; }
		void paint(QPainter *p);
		int height(const QListBox *lb) const;
		int width(const QListBox *lb) const;
		const QPixmap* pixmap() const;
		void setToolTipInfo(const QString &info);

		friend class UsersList;
};

#endif

