/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __STATUS_H
#define __STATUS_H

#include <qwidget.h>

class QComboBox;
class QPushButton;
class History;

class StatusWin: public QWidget
{
	Q_OBJECT
		
	private:
		QComboBox *infolist;
		QPushButton *b_ok;
		
	protected:
		//virtual bool close(bool alsoDelete);
		virtual void closeEvent(QCloseEvent *e);

	signals:
		void changeStatus(const QString &txt);
		void canceled();
		
	protected slots:
		virtual void accept();

	public:
		StatusWin(QWidget *parent, const QString &name, const History &list);
		~StatusWin();
};

#endif

