/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SCRIPTING_H
#define __SCRIPTING_H

class QString;
class QDateTime;
class QStringList;

class Scripting
{
	private:
		static bool run(const QString &fname, const QStringList &env);
	public:
		static void executeChatline(const QString &fname, const QDateTime &date, const QString &channel, const QString &from, const QString &text);
		static void executeMessage(const QString &fname, const QDateTime &date, const QString &from, const QString &text);
		static void executeJoin(const QString &fname, const QDateTime &date, const QString &channel, const QString &from);
		static void executeLeave(const QString &fname, const QDateTime &date, const QString &channel, const QString &from);
		static void executeBeep(const QString &fname, const QDateTime &date, const QString &from);
		static void executeInfoRequest(const QString &fname, const QDateTime &date, const QString &from);
		static void executeRegexpMatch(const QString &fname, const QDateTime &date, const QString &channel, const QString &from, const QString &text);
};

#endif

