/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __PACKETDATA_H
#define __PACKETDATA_H

#include "vcprotocol.h"
#include <stdlib.h>
#include <qcstring.h>

class PacketData
{
	private:
		unsigned char data[VY_MAXPACKETSIZE];
		int size;
		bool over; //indicates too long packet data
		
		inline void createHeader()
		{
			data[0] = 'X';
			//
			// packet id
			for (int i=1; i<11; i++)
				data[i] = (0x30 + random()%9);
		}

	public:
		PacketData(): size(10), over(false)
		{
			createHeader();
		}

		~PacketData()
		{
		}

		inline bool isOk() const { return !over; }
		
		const void *dataPtr() const { return data; }

		const unsigned int dataLength() const { return size; }
		
		inline PacketData& operator <<(const Q_INT8 c)
		{
			if (size < VY_MAXPACKETSIZE)
				data[size++] = c;
			else
				over = true;
			return *this;
		}

		inline PacketData& operator <<(const QCString &str)
		{
			const int n = str.length();
			if (size + n < VY_MAXPACKETSIZE)
			{
				memcpy(data + size, str.data(), n);
				size += n;
			}
			else
			{
				over = true;
			}
			return *this;
		}

		inline PacketData& operator <<(const QByteArray &array)
		{
			if (size + array.size() < VY_MAXPACKETSIZE)
			{
				memcpy(data + size, array.data(), array.size());
				size += array.size();
			}
			else
			{
				over = true;
			}
			return *this;
		}
};

#endif

