/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __NICKCOMBO_H
#define __NICKCOMBO_H

#include <qcombobox.h>

class QSettings;
class QStringList;

class NickCombo: public QComboBox
{
	Q_OBJECT
		
	private:
		static const QString key;
		
	public:
		NickCombo(QWidget *parent, int max=10);
		~NickCombo();
		QStringList getAll() const;
		bool save(QSettings *cfg);
		bool load(QSettings *cfg);
		bool exists(const QString &nick);
};

#endif

